/* -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_DESERIALIZER_H__
#define AKAXISO_XML_DESERIALIZER_DESERIALIZER_H__

#include <akaxiso/configuration.h>
#include <string>
#include <akaxiso/util/iosfwd.h>
#include <akaxiso/framework/document.h>

namespace aka2 {

  struct document;

  class deserializer {
  public:
    virtual ~deserializer() {}
    virtual document deserialize(std::istream &istm) = 0;  
    virtual document deserialize(const char *document) = 0;
    virtual document deserialize(const std::string &document) = 0;
    virtual document deserialize_stdin() = 0;
    virtual document deserialize_file(const std::string &filename) = 0; 
  };

  document deserialize(std::istream &istm);
  document deserialize(const char *document);
  document deserialize(const std::string &document);
  document deserialize_stdin();
  document deserialize_file(const std::string &filename);

} // namespace aka2

#endif
