#include "closure_handler.h"


using namespace aka2;


closure_handler::closure_handler(const qname &tagname, sequence_handler *seq, 
				 int depth)
  : handler(*seq, depth, tagname), seqhandler_(seq), inner_(0){}


validation_result closure_handler::query_element(const qname &tagname, 
						 const attribute_values &attrs) {
  inner_ = new sequence_handler(tagname, seqhandler_, depth_);
  context_.push(inner_);
  return inner_->query_element(tagname, attrs);
}

validation_result closure_handler::query_next(const qname &tagname, 
					      const attribute_values &attrs) {
  assert(!"Must not be called.");
  return ok;
}


validation_result closure_handler::end_element(const qname &tagname) {
  // Tag name is the same as one for enclose.
  // current_(point to member) should be disclose. 
  if ((tagname_ == tagname) && (seqhandler_->current_->get_schematype() == disclose_id))
    return ok;
  context_.report("Wrong xiso definition.", __FILE__, __LINE__);
  return invalid;
}

bool closure_handler::parse_entity(const std::string &entity) {
  return true;
}


node closure_handler::get_node(){
  return node(seqhandler_->seq_, seqhandler_->current_->op());
}

void closure_handler::receive_child(const node &mpair){
  seqhandler_->current_ = inner_->current_;
}

bool closure_handler::can_skip() {
  // Closure always appears.  Never skip. 
  return false;
}

