/* -*- c++ -*- */
#ifndef AKAXISO_XML_DESERIALIZER_ALL_HANDLER_H__
#define AKAXISO_XML_DESERIALIZER_ALL_HANDLER_H__

/** @file akaxiso/parser/all_handler.h */

#include <akaxiso/XML/deserializer/handler.h>
#include <akaxiso/framework/member_cache.h>

namespace aka2 {

  class all_handler : public handler {
  public:
    all_handler(const qname& tagname, void *seq, int depth,
		const all_op& sop, 
		parser_context &context);
    
    virtual ~all_handler(){}
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    validation_result parse_element(const member_type &mtype, const attribute_values &attrs);
    void *all_;
    const all_op &aop_;
    member_map mmap_;
    member_map::const_iterator current_;
    member_cache cache_;
  };

} // namespace aka2

#endif
