/* -*- c++ -*- */
#ifndef AKAXISO_BABEL_BABEL_SERIALIZER_H__
#define AKAXISO_BABEL_BABEL_SERIALIZER_H__

#include <akaxiso/configuration.h>

#ifdef USE_BABEL

#include <akaxiso/exception.h>
#include <akaxiso/XML/serializer/xml_serializer_base.h>
#include <akaxiso/imported/tricklib/tricklib.h>

namespace aka2 {

  class babel_formatter : public formatter_base {
  public:
    babel_formatter() {}
    virtual ~babel_formatter() {}

  private:
    virtual void set_encoding(const std::string &encoding);
    virtual ustring lcp_to_ucs2(const std::string &source);
    virtual void write(const ustring &entity);

    babel::bbl_translater<std::string, ustring> in_translator_;
    babel::bbl_translater<ustring, std::string> out_translator_;
  };


  class babel_serializer : public xml_serializer_base {
  public:
    babel_serializer(const std::string &encoding = DEFAULT_ENCODING)
    : xml_serializer_base(encoding) {
      formatter_ = shared_ptr<formatter_base>(new babel_formatter());
      formatter_->set_encoding(encoding);
    }
  };



} // namespace aka2

#endif

#endif
