/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.EraWork;
import ajd4jp.format.JapaneseYearF;
import java.io.Serializable;
import java.util.HashMap;

public enum Era {
    MEIJI("\u660e\u6cbb", EraWork.st_ed[0][0], EraWork.st_ed[0][1], "M", "\uff2d"),
    TAISHO("\u5927\u6b63", EraWork.st_ed[1][0], EraWork.st_ed[1][1], "T", "\uff34"),
    SHOWA("\u662d\u548c", EraWork.st_ed[2][0], EraWork.st_ed[2][1], "S", "\uff33"),
    HEISEI("\u5e73\u6210", EraWork.st_ed[3][0], EraWork.st_ed[3][1], "H", "\uff28"),
    REIWA("\u4ee4\u548c", EraWork.st_ed[4][0], EraWork.st_ed[4][1], "R", "\uff32");

    private HashMap<JapaneseYearF.Era, String> name = new HashMap();
    private AJD start;
    private AJD end = null;

    private Era(String n2, AJD s, AJD e, String h, String f) {
        this.start = s;
        this.end = e;
        this.name.put(JapaneseYearF.Era.KANJI, n2);
        this.name.put(JapaneseYearF.Era.HALF, h);
        this.name.put(JapaneseYearF.Era.FULL, f);
    }

    static Era get(Day ajd) {
        Era[] era = Era.values();
        for (int i = era.length - 1; i >= 0; --i) {
            if (era[i].start.compareTo(ajd) > 0) continue;
            return era[i];
        }
        return null;
    }

    public static Year getEra(int yyyy, int mm, int dd) throws AJDException {
        return new Year(new AJD(yyyy, mm, dd));
    }

    public String getName() {
        return this.getName(JapaneseYearF.Era.KANJI);
    }

    public String getName(JapaneseYearF.Era e) {
        return this.name.get((Object)e);
    }

    public AJD getStart() {
        return this.start;
    }

    public AJD getEnd() {
        return this.end;
    }

    public boolean isValid(AJD date) {
        if (date == null) {
            return false;
        }
        if (this.start.compareTo(date) > 0) {
            return false;
        }
        if (this.end == null) {
            return true;
        }
        return this.end.compareTo(date = date.trim()) >= 0;
    }

    public int getAD(int yy) {
        return this.start.getYear() + yy - 1;
    }

    public int getJP(int yyyy) {
        return yyyy - this.start.getYear() + 1;
    }

    public static class Year
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Era era;
        private int yy;

        private Year() {
        }

        public Year(Day ajd) {
            this.era = Era.get(ajd);
            int y4 = ajd.getYear();
            this.yy = this.era == null ? y4 : this.era.getJP(y4);
        }

        public Era getEra() {
            return this.era;
        }

        public int getYear() {
            return this.yy;
        }

        public String toString() {
            return String.format("%s%d\u5e74", this.era == null ? "" : this.era.getName(), this.yy);
        }
    }
}

