/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.AJD;
import ajd4jp.Day;
import ajd4jp.orrery.Angle;
import ajd4jp.util.Calc;
import java.math.BigDecimal;

public class ETD
implements Day {
    private static final long serialVersionUID = 1L;
    private BigDecimal A360 = new BigDecimal(360);
    private AJD ajd;
    private AJD jed;
    private static final BigDecimal T2000 = new BigDecimal(2451545);
    private static final BigDecimal J100 = new BigDecimal(36525);

    public ETD() {
        this(new AJD());
    }

    public ETD(BigDecimal jed) {
        this.jed = new AJD(jed);
        this.ajd = new AJD(jed.subtract(ETD.makeT(this.jed.getYear(), this.jed.getMonth())));
    }

    public ETD(AJD ajd, Angle longitude) {
        if (longitude != null) {
            longitude = longitude.convert(Angle.Unit.DEGREE);
            BigDecimal loc = Calc.div((BigDecimal)longitude.h, this.A360);
            loc = loc.subtract(Calc.JP_H);
            ajd = ajd.addDay(loc);
        }
        this.ajd = ajd;
        this.jed = new AJD(ajd.getAJD().add(ETD.makeT(this.ajd.getYear(), this.ajd.getMonth())));
    }

    public ETD(AJD ajd) {
        this(ajd, null);
    }

    public BigDecimal getJED() {
        return this.jed.getAJD();
    }

    @Override
    public BigDecimal getAJD() {
        return this.ajd.getAJD();
    }

    public BigDecimal get20C() {
        return Calc.div(this.getJED().subtract(T2000), J100);
    }

    @Override
    public AJD toAJD() {
        return this.ajd;
    }

    @Override
    public int getYear() {
        return this.jed.getYear();
    }

    @Override
    public int getMonth() {
        return this.jed.getMonth();
    }

    @Override
    public int getDay() {
        return this.jed.getDay();
    }

    @Override
    public int getHour() {
        return this.jed.getHour();
    }

    @Override
    public int getMinute() {
        return this.jed.getMinute();
    }

    @Override
    public int getSecond() {
        return this.jed.getSecond();
    }

    @Override
    public int compareTo(Day jd) {
        if (jd instanceof ETD) {
            return this.jed.compareTo(((ETD)jd).jed);
        }
        return this.ajd.compareTo(jd);
    }

    public int hashCode() {
        return this.ajd.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ETD) {
            return this.jed.equals(((ETD)o).jed);
        }
        return this.ajd.equals(o);
    }

    public String toString() {
        return this.jed.toString();
    }

    private static double pow(double org, int cnt) {
        double ret = 1.0;
        for (int i = 0; i < cnt; ++i) {
            ret *= org;
        }
        return ret;
    }

    private static BigDecimal makeT(int year, int month) {
        double t = ETD._makeT(year, month);
        return Calc.div(new BigDecimal(t), Calc.J86400);
    }

    private static double _makeT(int year, int month) {
        double y = (double)year + ((double)month - 0.5) / 12.0;
        if (year < -500) {
            double u = (year - 1820) / 100;
            return -20.0 + 32.0 * ETD.pow(u, 2);
        }
        if (year < 500) {
            double u = y / 100.0;
            return 10583.6 - 1014.41 * u + 33.78311 * ETD.pow(u, 2) - 5.952053 * ETD.pow(u, 3) - 0.1798452 * ETD.pow(u, 4) + 0.022174192 * ETD.pow(u, 5) + 0.0090316521 * ETD.pow(u, 6);
        }
        if (year < 1600) {
            double u = (y - 1000.0) / 100.0;
            return 1574.2 - 556.01 * u + 71.23472 * ETD.pow(u, 2) + 0.319781 * ETD.pow(u, 3) - 0.8503463 * ETD.pow(u, 4) - 0.005050998 * ETD.pow(u, 5) + 0.0083572073 * ETD.pow(u, 6);
        }
        if (year < 1700) {
            double t = y - 1600.0;
            return 120.0 - 0.9808 * t - 0.01532 * ETD.pow(t, 2) + ETD.pow(t, 3) / 7129.0;
        }
        if (year < 1800) {
            double t = y - 1700.0;
            return 8.83 + 0.1603 * t - 0.0059285 * ETD.pow(t, 2) + 1.3336E-4 * ETD.pow(t, 3) - ETD.pow(t, 4) / 1174000.0;
        }
        if (year < 1860) {
            double t = y - 1800.0;
            return 13.72 - 0.332447 * t + 0.0068612 * ETD.pow(t, 2) + 0.0041116 * ETD.pow(t, 3) - 3.7436E-4 * ETD.pow(t, 4) + 1.21272E-5 * ETD.pow(t, 5) - 1.699E-7 * ETD.pow(t, 6) + 8.75E-10 * ETD.pow(t, 7);
        }
        if (year < 1900) {
            double t = y - 1860.0;
            return 7.62 + 0.5737 * t - 0.251754 * ETD.pow(t, 2) + 0.01680668 * ETD.pow(t, 3) - 4.473624E-4 * ETD.pow(t, 4) + ETD.pow(t, 5) / 233174.0;
        }
        if (year < 1920) {
            double t = y - 1900.0;
            return -2.79 + 1.494119 * t - 0.0598939 * ETD.pow(t, 2) + 0.0061966 * ETD.pow(t, 3) - 1.97E-4 * ETD.pow(t, 4);
        }
        if (year < 1941) {
            double t = y - 1920.0;
            return 21.2 + 0.84493 * t - 0.0761 * ETD.pow(t, 2) + 0.0020936 * ETD.pow(t, 3);
        }
        if (year < 1961) {
            double t = y - 1950.0;
            return 29.07 + 0.407 * t - ETD.pow(t, 2) / 233.0 + ETD.pow(t, 3) / 2547.0;
        }
        if (year < 1986) {
            double t = y - 1975.0;
            return 45.45 + 1.067 * t - ETD.pow(t, 2) / 260.0 - ETD.pow(t, 3) / 718.0;
        }
        if (year < 2005) {
            double t = y - 2000.0;
            return 63.86 + 0.3345 * t - 0.060374 * ETD.pow(t, 2) + 0.0017275 * ETD.pow(t, 3) + 6.51814E-4 * ETD.pow(t, 4) + 2.373599E-5 * ETD.pow(t, 5);
        }
        if (year < 2050) {
            double t = y - 2000.0;
            return 62.92 + 0.32217 * t + 0.005589 * ETD.pow(t, 2);
        }
        if (year < 2150) {
            return -20.0 + 32.0 * ETD.pow((y - 1820.0) / 100.0, 2) - 0.5628 * (2150.0 - y);
        }
        double u = (year - 1820) / 100;
        return -20.0 + 32.0 * ETD.pow(u, 2);
    }
}

