/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.orrery;

import ajd4jp.AJDException;
import ajd4jp.orrery.Angle;
import ajd4jp.orrery.ETD;
import ajd4jp.orrery.Ephemeris;
import ajd4jp.orrery.Planet;
import ajd4jp.orrery.Raw;
import ajd4jp.orrery.tool.JPLItem;
import ajd4jp.util.Calc;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class Dim3
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal x;
    private BigDecimal y;
    private BigDecimal z;

    private Dim3() {
        this.y = this.z = BigDecimal.ZERO;
        this.x = this.z;
    }

    private Dim3(BigDecimal a, BigDecimal b, BigDecimal c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    private Dim3(Raw r) {
        this.x = r.x;
        this.y = r.y;
        this.z = r.z;
    }

    public static Dim3 plot(ETD jed, Planet planet, Planet origin) throws AJDException, IOException {
        Ephemeris.check();
        if (planet == origin) {
            return new Dim3();
        }
        Dim3 ret = null;
        if (planet.item != null) {
            ret = new Dim3(Raw.getRaw(jed, planet.item));
        } else if (planet == Planet.EARTH) {
            Raw emb = Raw.getRaw(jed, JPLItem.EARTH_MOON_BARYCENTER);
            Raw moon = Raw.getRaw(jed, JPLItem.MOON);
            BigDecimal r = Ephemeris.EMB;
            ret = new Dim3(emb.x.subtract(r.multiply(moon.x)), emb.y.subtract(r.multiply(moon.y)), emb.z.subtract(r.multiply(moon.z)));
        } else if (planet == Planet.SOLAR_SYSTEM_BARYCENTER) {
            ret = new Dim3();
        }
        if (planet == Planet.MOON) {
            if (origin == Planet.EARTH) {
                return ret;
            }
            Dim3 earth = Dim3.plot(jed, Planet.EARTH, Planet.SOLAR_SYSTEM_BARYCENTER);
            ret = ret.add(earth);
        }
        if (origin == Planet.SOLAR_SYSTEM_BARYCENTER) {
            return ret;
        }
        return ret.subtract(Dim3.plot(jed, origin, Planet.SOLAR_SYSTEM_BARYCENTER));
    }

    public Dim3 add(Dim3 a) {
        return new Dim3(this.x.add(a.x), this.y.add(a.y), this.z.add(a.z));
    }

    private Dim3 add(Raw a) {
        return new Dim3(this.x.add(a.x), this.y.add(a.y), this.z.add(a.z));
    }

    public Dim3 subtract(Dim3 a) {
        return new Dim3(this.x.subtract(a.x), this.y.subtract(a.y), this.z.subtract(a.z));
    }

    private Dim3 subtract(Raw a) {
        return new Dim3(this.x.subtract(a.x), this.y.subtract(a.y), this.z.subtract(a.z));
    }

    public Dim3 negate() {
        return new Dim3(this.x.negate(), this.y.negate(), this.z.negate());
    }

    public Dim3 rotateX(Angle a) {
        double p = a.convert((Angle.Unit)Angle.Unit.RADIAN).h.doubleValue();
        BigDecimal s = new BigDecimal(Math.sin(p));
        BigDecimal c = new BigDecimal(Math.cos(p));
        BigDecimal dy = c.multiply(this.y).add(s.multiply(this.z));
        BigDecimal dz = c.multiply(this.z).subtract(s.multiply(this.y));
        return new Dim3(this.x, dy, dz);
    }

    public Dim3 rotateY(Angle a) {
        double p = a.convert((Angle.Unit)Angle.Unit.RADIAN).h.doubleValue();
        BigDecimal s = new BigDecimal(Math.sin(p));
        BigDecimal c = new BigDecimal(Math.cos(p));
        BigDecimal dx = c.multiply(this.x).subtract(s.multiply(this.z));
        BigDecimal dz = s.multiply(this.x).add(c.multiply(this.z));
        return new Dim3(dx, this.y, dz);
    }

    public Dim3 rotateZ(Angle a) {
        double p = a.convert((Angle.Unit)Angle.Unit.RADIAN).h.doubleValue();
        BigDecimal s = new BigDecimal(Math.sin(p));
        BigDecimal c = new BigDecimal(Math.cos(p));
        BigDecimal dx = c.multiply(this.x).add(s.multiply(this.y));
        BigDecimal dy = c.multiply(this.y).subtract(s.multiply(this.x));
        return new Dim3(dx, dy, this.z);
    }

    public XYZ get(Unit u) {
        if (u == Unit.KM) {
            return new XYZ(this.x, this.y, this.z);
        }
        return new XYZ(Calc.div(this.x, Ephemeris.AU), Calc.div(this.y, Ephemeris.AU), Calc.div(this.z, Ephemeris.AU));
    }

    public static enum Unit {
        KM,
        AU;

    }

    public static class XYZ
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public BigDecimal x;
        public BigDecimal y;
        public BigDecimal z;

        public XYZ(Number x, Number y, Number z) {
            this.x = new BigDecimal(x.toString());
            this.y = new BigDecimal(y.toString());
            this.z = new BigDecimal(z.toString());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("(");
            buf.append(Calc.toString(this.x)).append(", ");
            buf.append(Calc.toString(this.y)).append(", ");
            buf.append(Calc.toString(this.z)).append(")");
            return buf.toString();
        }
    }
}

