/*
 * AJD4JP
 * Copyright (c) 2011-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package ajd4jp;

/**
 * 年度。会計年度のような、年の開始が1/1でない期間を扱います。
 */
public class FiscalYear implements java.io.Serializable {
	private static final long serialVersionUID = 1;
	private static AJD	START4 = null;
	static {
		try{
			START4 = new AJD( 2000, 4, 1 );
		}
		catch( AJDException e ){}
	}

	private int start_m, start_d;
	private boolean mon_f;

	/**
	 * コンストラクタ。<br>
	 * new FiscalYear(new AJD(2000, 4, 1), true) と等価です。<br>
	 * 会計年度のような4/1を開始日とする一般的な年度を構築します。
	 */
	public FiscalYear() {
		this( START4, true );
	}

	/**
	 * コンストラクタ。<br>
	 * 開始日と、年を開始日で取るか終了日で取るかを指定します。<br><br>例
	 * <ul>
	 * <li>醸造・酒造年度(7/1～) 年は開始日<br>
	 * new FiscalYear(new AJD(2000, 7, 1), true)<br>
	 * 2000/6/30は、1999年度6/30です。<br>
	 * 2000/7/1 は、2000年度7/1 です。
	 * <li>羊毛年度(7/1～) 年は終了日<br>
	 * new FiscalYear(new AJD(2000, 7, 1), false)<br>
	 * 2000/6/30は、2000年度6/30です。<br>
	 * 2000/7/1 は、2001年度7/1 です。
	 * </ul>
	 * @param start_day 年度開始日。指定日の月と日を判定条件に使用します。
	 * @param year_of_start_day true:年は開始日と同じ、false:年は終了日と同じ。
	 */
	public FiscalYear( AJD start_day, boolean year_of_start_day ) {
		start_m = start_day.getMonth();
		start_d = start_day.getDay();
		mon_f = year_of_start_day;
	}

	private AJD getStart( int y, int m, int d ) {
		try {
			return new AJD( y, m, d );
		}
		catch( AJDException e ) {}
		return getStart( y, m, d - 1 );
	}
	private AJD getStart( int y ) {
		return getStart( y, start_m, start_d );
	}

	int getYear( AJD ajd ) {
		int	y = ajd.getYear();
		AJD	st = getStart( y );
		if ( st.compareTo( ajd ) > 0 && mon_f )	{
			y--;
			if ( y == 0 )	y--;
		}
		else if ( st.compareTo( ajd ) <= 0 && !mon_f ) {
			y++;
			if ( y == 0 )	y++;
		}
		return y;
	}

	/**
	 * 年度換算日の取得。
	 * @param day 換算元。
	 * @return 換算日。
	 */
	public FYD getFYD( AJD day ) {
		return new FYD( this, day );
	}

	/**
	 * 指定日の取得。時間は00:00:00になります。
	 * @param yyyy 年度。
	 * @param mm 月。
	 * @param dd 日。
	 * @return 年度換算日。
	 */
	public FYD getFYD( int yyyy, int mm, int dd ) throws AJDException {
		return getFYD( yyyy, mm, dd, 0, 0, 0 );
	}

	private AJD getAJD( int yyyy, int mm, int dd, int hh, int mi, int ss ) {
		try {
			return new AJD( yyyy, mm, dd, hh, mi, ss );
		}
		catch( AJDException e ){}
		return null;
	}
	/**
	 * 指定日の取得。
	 * @param yyyy 年度。
	 * @param mm 月。
	 * @param dd 日。
	 * @param hh 時。
	 * @param mi 分。
	 * @param ss 秒。
	 * @return 年度換算日。
	 */
	public FYD getFYD( int yyyy, int mm, int dd, int hh, int mi, int ss ) throws AJDException {
		FYD[]	fyd = new FYD[] {
			new FYD( this, getAJD( yyyy - 1, mm, dd, hh, mi, ss ) ),
			new FYD( this, getAJD( yyyy, mm, dd, hh, mi, ss ) ),
			new FYD( this, getAJD( yyyy + 1, mm, dd, hh, mi, ss ) )
		};
		for ( int i = 0; i < fyd.length; i++ ) {
			if ( fyd[i].ajd == null )	continue;
			if ( fyd[i].getYear() == yyyy )	return fyd[i];
		}
		throw new AJDException( "指定日が存在しません。" );
	}
}

