/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp.web.logic;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Holiday;
import ajd4jp.Month;
import java.io.Serializable;
import paraselene.Color;
import paraselene.EphemeralPage;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.QueryItem;
import paraselene.WebColor;
import paraselene.css.CSSValuable;
import paraselene.supervisor.Closure;
import paraselene.supervisor.EphemeralClosure;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.Forward;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Anchor;
import paraselene.tag.form.Control;
import paraselene.tag.form.Select;
import paraselene.tag.table.Column;
import paraselene.tag.table.Line;
import paraselene.tag.table.Table;

public class JpCalendarHtml
extends ajd4jp.web.view.JpCalendarHtml
implements EphemeralPage {
    private static final long serialVersionUID = 1L;
    private Param param;
    private Month mon;

    public JpCalendarHtml() {
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.replaceFeedbackURI(new String[]{"jp_calendar.html"});
        this.getYearSelect().setSubmitEvent(new Control.SubmitEvent[]{Control.SubmitEvent.CHANGE});
        this.getMonthSelect().setSubmitEvent(new Control.SubmitEvent[]{Control.SubmitEvent.CHANGE});
    }

    public String getAliasURI() {
        return null;
    }

    public Forward inputMain(RequestParameter req, Forward fw) throws Page.PageException {
        try {
            if (req.getItem("close") != null) {
                return new Closure();
            }
            RequestItem day = req.getItem("day");
            int year = Integer.parseInt(this.getYearSelect().getValueString());
            int month = Integer.parseInt(this.getMonthSelect().getValueString());
            if (day != null) {
                return new EphemeralClosure((Object)new AJD(year, month, Integer.parseInt(day.getValue())));
            }
            this.mon = req.getItem("prev") != null ? this.mon.add(-1) : (req.getItem("next") != null ? this.mon.add(1) : new Month(year, month));
            return new Feedback();
        }
        catch (AJDException e) {
            throw new Page.PageException((Throwable)e);
        }
    }

    public void firstOutput(RequestParameter req, Object p) throws Page.PageException {
        AJD today = new AJD();
        this.param = (Param)p;
        Select year = this.getYearSelect();
        Select month = this.getMonthSelect();
        year.makeSequenceNo(this.param.from.getYear(), this.param.to.getYear());
        month.makeSequenceNo(1, 12);
        if (this.param.mine.compareTo(this.param.from) < 0) {
            this.param.mine = this.param.from;
        } else if (this.param.mine.compareTo(this.param.to) > 0) {
            this.param.mine = this.param.to;
        }
        try {
            this.mon = new Month(this.param.mine.getYear(), this.param.mine.getMonth());
        }
        catch (AJDException e) {
            throw new Page.PageException((Throwable)e);
        }
        this.addOnLoadStyle(new String[]{this.getFirstTagByType("style").getValueString()});
    }

    public void firstOutputMain(RequestParameter req) throws Page.PageException {
        this.firstOutput(req, null);
    }

    public Page outputMain(Page from, RequestParameter req) throws Page.PageException {
        AJD[] w;
        Select year = this.getYearSelect();
        Select month = this.getMonthSelect();
        year.setValueString(Integer.toString(this.mon.getYear()));
        month.setValueString(Integer.toString(this.mon.getMonth()));
        AJD[] all = this.mon.getDays();
        Table table = this.getMainTable();
        table.removeLine();
        int i = 1;
        while ((w = this.mon.getWeek(i, false)) != null) {
            Line line = new Line();
            for (int j = 0; j < w.length; ++j) {
                Column column = new Column(Column.Type.DATA);
                line.addColumn(column);
                if (w[j] == null) continue;
                int day = w[j].getDay();
                String val = Integer.toString(day);
                String str = null;
                if (day < 10) {
                    StringBuilder buf = new StringBuilder("\u3000");
                    str = buf.append(val).toString();
                } else {
                    str = val;
                }
                boolean flag = false;
                for (AJD ex : this.param.ex) {
                    if (!ex.equals(w[j])) continue;
                    flag = true;
                    break;
                }
                if (flag || w[j].compareTo(this.param.from) < 0 || w[j].compareTo(this.param.to) > 0) {
                    column.setValueString(str);
                    continue;
                }
                Holiday h = Holiday.getHoliday(w[j]);
                if (j == 0 || h != null) {
                    column.setAttribute("class", "sun");
                } else if (j == 6) {
                    column.setAttribute("class", "sat");
                }
                Anchor a = new Anchor();
                a.setAttribute(this.createPageToURI("href", this.getID(), null, new QueryItem[]{new QueryItem("day", val)}));
                if (h != null) {
                    a.setAttribute("title", h.getName(w[j]));
                }
                a.setValueString(str);
                column.addHTMLPart((HTMLPart)a);
            }
            table.addLine(line);
            ++i;
        }
        AJD prev = all[0].addDay(-1);
        AJD next = all[all.length - 1].addDay(1);
        this.getPrevA().setVisible(all[0].addDay(-1).compareTo(this.param.from) >= 0);
        this.getNextA().setVisible(all[all.length - 1].addDay(1).compareTo(this.param.to) <= 0);
        this.getChangeInput().setVisible(!req.wasUsedAjax());
        return this;
    }

    public CSSValuable[] getPopupBackGround() {
        return new CSSValuable[]{new Color(WebColor.WHITE)};
    }

    public static class Param
    implements Serializable {
        private static final long serialVersionUID = 1L;
        AJD from;
        AJD mine;
        AJD to;
        AJD[] ex;

        public Param(AJD f, AJD m, AJD t, AJD ... e) {
            this.from = f.trim();
            if (m != null) {
                this.mine = m.trim();
            }
            this.to = t.trim();
            if (e != null) {
                this.ex = new AJD[e.length];
                for (int i = 0; i < this.ex.length; ++i) {
                    this.ex[i] = e[i].trim();
                }
            } else {
                e = new AJD[]{};
            }
        }

        public void setMine(AJD m) {
            this.mine = m;
        }
    }
}

