/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.Day;

public enum EarthlyBranch {
    SHI("\u5b50", 0),
    CHU("\u4e11", 1),
    IN("\u5bc5", 2),
    BOU("\u536f", 3),
    SHIN("\u8fb0", 4),
    SI("\u5df3", 5),
    GO("\u5348", 6),
    BI("\u672a", 7),
    SIN("\u7533", 8),
    YU("\u9149", 9),
    JUTSU("\u620c", 10),
    GAI("\u4ea5", 11);

    private String name;
    private int no;
    private static final EarthlyBranch[] eb;

    private EarthlyBranch(String s, int n2) {
        this.name = s;
        this.no = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getNo() {
        return this.no;
    }

    private static EarthlyBranch fix(int v) {
        if ((v %= eb.length) < 0) {
            v += eb.length;
        }
        return eb[v];
    }

    public static EarthlyBranch getYear(Day date) {
        int yy = date.getYear();
        if (yy < 0) {
            ++yy;
        }
        return EarthlyBranch.fix(yy - 4);
    }

    public static EarthlyBranch getMonth(Day date) {
        return EarthlyBranch.fix(date.getMonth() - 11);
    }

    public static EarthlyBranch getDay(Day date) {
        AJD ajd = new AJD(date.getAJD());
        return EarthlyBranch.fix((int)AJD.cut(ajd.trim().getAJD()) - 10);
    }

    public static EarthlyBranch getTime(Day date) {
        return EarthlyBranch.fix((date.getHour() + 1) / 2);
    }

    static {
        eb = EarthlyBranch.values();
    }
}

