/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJDException;
import ajd4jp.Day;
import ajd4jp.Era;
import ajd4jp.Month;
import ajd4jp.Week;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class AJD
implements Day {
    private static final long serialVersionUID = 1L;
    static final BigDecimal FIX05 = new BigDecimal("0.50000000");
    static final BigDecimal FIX_05 = new BigDecimal("-0.50000000");
    private BigDecimal ajd;
    static final BigDecimal JP_H = new BigDecimal("0.375");
    private static final BigDecimal EPOCH = new BigDecimal("2440587.50000000000000000000");
    private static final BigDecimal HOUR = AJD.div(BigDecimal.ONE, 24L);
    private static final BigDecimal MIN = AJD.div(HOUR, 60L);
    private static final BigDecimal SEC = AJD.div(MIN, 60L);
    private static final BigDecimal MSEC = AJD.div(SEC, 1000L);
    private int year;
    private int mon;
    private int day;
    private int hour;
    private int min;
    private int sec;
    private Era.Year era = null;
    private Week week = null;
    private static final BigDecimal DATE_FIX = new BigDecimal("0.000000000000000001");
    private static final BigDecimal J122_1 = new BigDecimal("122.1");
    private static final BigDecimal J365_25 = new BigDecimal("365.25");
    private static final BigDecimal J30_6001 = new BigDecimal("30.6001");
    static final BigDecimal J86400 = new BigDecimal("86400.00000000000000000000");
    private transient Integer hash = null;

    public long getTime() {
        return AJD.up(AJD.mul(AJD.mul(AJD.mul(AJD.mul(this.ajd.subtract(EPOCH), 24L), 60L), 60L), 1000L));
    }

    public AJD addSecond(long ss) {
        if (ss == 0L) {
            return this;
        }
        return new AJD(this.ajd.add(new BigDecimal(ss).multiply(SEC)));
    }

    public AJD addMinute(long mm) {
        if (mm == 0L) {
            return this;
        }
        return new AJD(this.ajd.add(new BigDecimal(mm).multiply(MIN)));
    }

    public AJD addHour(long hh) {
        if (hh == 0L) {
            return this;
        }
        return new AJD(this.ajd.add(new BigDecimal(hh).multiply(HOUR)));
    }

    public AJD addDay(Number dd) {
        BigDecimal d = new BigDecimal(dd.toString());
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        return new AJD(this.ajd.add(d));
    }

    public String toString() {
        return String.format("%d/%02d/%02d %02d:%02d:%02d[%s]", this.year, this.mon, this.day, this.hour, this.min, this.sec, this.ajd);
    }

    @Override
    public int getYear() {
        return this.year;
    }

    public Era.Year getEra() {
        if (this.era == null) {
            this.era = new Era.Year(this);
        }
        return this.era;
    }

    @Override
    public int getMonth() {
        return this.mon;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    public Week getWeek() {
        if (this.week == null) {
            this.week = Week.get(this);
        }
        return this.week;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.min;
    }

    @Override
    public int getSecond() {
        return this.sec;
    }

    static long up(BigDecimal d) {
        return d.setScale(0, 0).longValue();
    }

    static long cut(BigDecimal d) {
        return d.setScale(0, 1).longValue();
    }

    static BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b, 30, 4);
    }

    static BigDecimal div(BigDecimal a, long b) {
        return AJD.div(a, new BigDecimal(b));
    }

    static BigDecimal mul(BigDecimal a, long b) {
        return a.multiply(new BigDecimal(b));
    }

    public AJD() {
        this(new Date());
    }

    public AJD(Date date) {
        this(AJD.mul(MSEC, date.getTime()).add(EPOCH));
    }

    public AJD(Day date) {
        this(date.getAJD());
    }

    public AJD(Calendar calendar) {
        this(calendar.getTime());
    }

    private void set(BigDecimal offset) {
        BigDecimal tmp = this.ajd.add(offset);
        long jd = AJD.cut(tmp);
        if ((tmp = tmp.subtract(new BigDecimal(jd))).compareTo(FIX05) >= 0) {
            ++jd;
            tmp = tmp.subtract(FIX05);
        } else {
            tmp = tmp.add(FIX05);
        }
        if (jd >= 2299161L) {
            jd = jd + 1L + (jd - 1867216L) / 36524L - (jd - 1867216L) / 146096L;
        }
        BigDecimal bjd = new BigDecimal(jd += 1524L);
        long c = AJD.cut(AJD.div(bjd.subtract(J122_1), J365_25));
        long k = c * 365L + c / 4L;
        long e = AJD.cut(AJD.div(bjd.subtract(new BigDecimal(k)), J30_6001));
        this.year = (int)(c - 4716L);
        this.mon = (int)(e - 1L);
        if (this.mon > 12) {
            this.mon -= 12;
            ++this.year;
        }
        if (this.year <= 0) {
            --this.year;
        }
        this.day = (int)(jd - k - AJD.cut(new BigDecimal("30.6").multiply(new BigDecimal(e))));
        long s = AJD.cut(tmp.multiply(J86400).add(FIX05));
        this.hour = (int)(s / 3600L);
        if (this.hour >= 24) {
            this.ajd = this.ajd.add(DATE_FIX);
            this.set(offset);
            return;
        }
        this.min = (int)(s % 3600L / 60L);
        this.sec = (int)(s % 60L);
    }

    public AJD(Number num) {
        this.ajd = new BigDecimal(num.toString()).abs();
        this.set(JP_H);
    }

    public AJD(int yyyy, int mm, int dd, int hh, int mi, int ss) throws AJDException {
        this.initAJD(yyyy, mm, dd, hh, mi, ss, JP_H);
    }

    AJD(int yyyy, int mm, int dd, int dummy) {
        try {
            this.initAJD(yyyy, mm, dd, 0, 0, 0, JP_H);
        }
        catch (AJDException e) {
            // empty catch block
        }
    }

    public AJD(int yyyy, int mm, int dd) throws AJDException {
        this(yyyy, mm, dd, 0, 0, 0);
    }

    static int check(int yy, int mm) throws AJDException {
        if (yy == 0) {
            throw new AJDException("\u5e74\u304c0\u3067\u3059\u3002");
        }
        if (mm < 1 || mm > 12) {
            throw new AJDException("\u6708\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (yy < 0) {
            ++yy;
        }
        return yy;
    }

    void initAJD(int yy, int mm, int dd, int hh, int mi, int ss, BigDecimal offset) throws AJDException {
        BigDecimal ret;
        long jd;
        boolean gre_f;
        if (dd < 1 || dd > new Month(yy, mm).getLastDay()) {
            throw new AJDException("\u65e5\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (hh < 0 || hh > 23) {
            throw new AJDException("\u6642\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (mi < 0 || mi > 59) {
            throw new AJDException("\u5206\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        if (ss < 0 || ss > 59) {
            throw new AJDException("\u79d2\u304c\u7bc4\u56f2\u5916\u3067\u3059\u3002");
        }
        this.year = yy;
        yy = AJD.check(yy, mm);
        this.mon = mm;
        this.day = dd;
        this.hour = hh;
        this.min = mi;
        this.sec = ss;
        boolean bc_f = yy <= 0;
        boolean bl = gre_f = yy > 1582 || yy == 1582 && mm > 10 || yy == 1582 && mm == 10 && dd >= 15;
        if (mm <= 2) {
            --yy;
            mm += 12;
        }
        if (hh < 12) {
            jd = 0L;
            ret = FIX05;
        } else {
            jd = 1L;
            ret = FIX_05;
        }
        ret = ret.add(AJD.div(new BigDecimal(hh * 3600 + mi * 60 + ss), J86400));
        jd += bc_f ? (long)((yy - 3) / 4) : (long)(yy / 4);
        if (gre_f) {
            jd += (long)(2 - yy / 100 + yy / 400);
        }
        this.ajd = ret.add(new BigDecimal(jd += (long)(1720994 + yy * 365 + (mm + 1) * 30 + (mm + 1) * 3 / 5 + dd))).subtract(offset);
        if (this.ajd.signum() == -1) {
            throw new AJDException("\u30e6\u30ea\u30a6\u30b9\u901a\u65e5\u57fa\u6e96\u65e5\u3088\u308a\u904e\u53bb\u306e\u65e5\u4ed8\u306b\u306a\u308a\u307e\u3057\u305f\u3002");
        }
    }

    @Override
    public BigDecimal getAJD() {
        return this.ajd;
    }

    @Override
    public AJD toAJD() {
        return this;
    }

    @Override
    public int compareTo(Day jd) {
        return this.ajd.compareTo(jd.getAJD());
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = this.ajd.toString().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o instanceof Day) {
            return this.compareTo((Day)o) == 0;
        }
        return false;
    }

    public AJD trim() {
        AJD ret = null;
        try {
            ret = new AJD(this.year, this.mon, this.day);
            if (ret.equals(this)) {
                return this;
            }
        }
        catch (AJDException aJDException) {
            // empty catch block
        }
        return ret;
    }

    public java.sql.Date toDate() {
        return new java.sql.Date(this.trim().getTime());
    }

    public Time toTime() {
        try {
            return new Time(new AJD(1970, 1, 1, this.getHour(), this.getMinute(), this.getSecond()).getTime());
        }
        catch (AJDException aJDException) {
            return null;
        }
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }
}

