/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.Day;
import ajd4jp.EarthlyBranch;
import ajd4jp.HeavenlyStem;
import java.io.Serializable;

public class SexagenaryCycle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final HeavenlyStem[] hs = HeavenlyStem.values();
    private static final EarthlyBranch[] eb = EarthlyBranch.values();
    private HeavenlyStem stem;
    private EarthlyBranch branch;

    public SexagenaryCycle(HeavenlyStem h, EarthlyBranch e) {
        this.stem = h;
        this.branch = e;
    }

    public HeavenlyStem getHeavenlyStem() {
        return this.stem;
    }

    public EarthlyBranch getEarthlyBranch() {
        return this.branch;
    }

    public String toString() {
        if (this.stem == null || this.branch == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(this.stem.getName());
        return buf.append(this.branch.getName()).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SexagenaryCycle) {
            SexagenaryCycle s = (SexagenaryCycle)o;
            return this.stem == s.stem && this.branch == s.branch;
        }
        return false;
    }

    public int hashCode() {
        return this.getNo();
    }

    public static int getNo(HeavenlyStem h, EarthlyBranch b) {
        if (h == null || b == null) {
            return -1;
        }
        int h_no = 0;
        int b_no = 0;
        for (int no = 0; no < 60; ++no) {
            if (h_no == h.getNo() && b_no == b.getNo()) {
                return no;
            }
            h_no = (h_no + 1) % hs.length;
            b_no = (b_no + 1) % eb.length;
        }
        return -1;
    }

    public int getNo() {
        return SexagenaryCycle.getNo(this.stem, this.branch);
    }

    public static SexagenaryCycle getSexagenaryCycle(int no) {
        if (no < 0 || no >= 60) {
            return null;
        }
        return new SexagenaryCycle(hs[no % hs.length], eb[no % eb.length]);
    }

    public static SexagenaryCycle getYear(Day date) {
        return new SexagenaryCycle(HeavenlyStem.getYear(date), EarthlyBranch.getYear(date));
    }

    public static SexagenaryCycle getMonth(Day date) {
        return new SexagenaryCycle(HeavenlyStem.getMonth(date), EarthlyBranch.getMonth(date));
    }

    public static SexagenaryCycle getDay(Day date) {
        return new SexagenaryCycle(HeavenlyStem.getDay(date), EarthlyBranch.getDay(date));
    }

    public static SexagenaryCycle getTime(Day date) {
        return new SexagenaryCycle(HeavenlyStem.getTime(date), EarthlyBranch.getTime(date));
    }
}

