/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;
import ajd4jp.AJDException;
import ajd4jp.Equinox;
import ajd4jp.LSCD;
import ajd4jp.STCD;
import ajd4jp.Saku;
import ajd4jp.Span;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class LunisolarYear
implements Comparable<LunisolarYear>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int START = 270;
    private static final int BASE_MON = 11;
    private static HashMap<Integer, LunisolarYear> map = new HashMap();
    private int yy;
    private Saku[] month;
    private Saku limit;

    private static boolean isHit(int start, int end) {
        if (start > end) {
            end += 360;
        }
        for (int i = start / 30 * 30; i < end; i += 30) {
            if (start > i || i >= end) continue;
            return true;
        }
        return false;
    }

    private static Saku[] countMon(int year, Saku[] saku, int start, int end) {
        int i;
        ArrayList<Saku> list = new ArrayList<Saku>();
        for (int cnt = start + 1; cnt < end; ++cnt) {
            if (!saku[cnt].start_f) continue;
            list.add(saku[cnt]);
        }
        saku = list.toArray(new Saku[0]);
        if (saku.length < 13) {
            saku[0].year = year++;
            saku[0].mon = 12;
            if (year == 0) {
                ++year;
            }
            for (int i2 = 1; i2 < saku.length; ++i2) {
                saku[i2].year = year;
                saku[i2].mon = i2;
            }
            return saku;
        }
        int mm = 11;
        boolean set_f = false;
        for (i = 1; i < saku.length; ++i) {
            if (set_f || LunisolarYear.isHit(saku[i - 1].sun, saku[i].sun)) {
                if (++mm > 12) {
                    mm = 1;
                    if (++year == 0) {
                        // empty if block
                    }
                }
            } else {
                set_f = true;
                saku[i - 1].leap_f = true;
            }
            saku[i - 1].year = ++year;
            saku[i - 1].mon = mm;
        }
        saku[i - 1].year = year;
        saku[i - 1].mon = 11;
        if (saku[i - 2].mon == 11) {
            saku[i - 1].leap_f = true;
        }
        return saku;
    }

    private static int getSun(AJD ajd) {
        int ret;
        BigDecimal sun = Equinox.getSun(ajd.getAJD());
        if (sun.compareTo(BigDecimal.ZERO) < 0) {
            sun = sun.add(Equinox.R360);
        }
        if ((ret = (int)AJD.cut(sun)) % 30 == 0 && BigDecimal.ZERO.compareTo(sun = sun.subtract(new BigDecimal(ret))) != 0) {
            ++ret;
        }
        return ret;
    }

    private static LunisolarYear get11(AJD ajd) {
        int i;
        int sun = LunisolarYear.getSun(ajd);
        int year = ajd.getYear();
        if (sun > 270 && --year == 0) {
            --year;
        }
        AJD[] toji = new AJD[4];
        int yyyy = year - 1;
        if (yyyy == 0) {
            --yyyy;
        }
        for (int i2 = 0; i2 < toji.length; ++i2) {
            toji[i2] = STCD.getStart(yyyy, 270);
            if (++yyyy != 0) continue;
            ++yyyy;
        }
        int day = new Span(toji[0], toji[3]).getDayPart();
        Saku[] saku = new Saku[day + 1];
        for (int i3 = 0; i3 < saku.length; ++i3) {
            saku[i3] = new Saku();
        }
        saku[0].ajd = toji[0];
        saku[0].sun = 270;
        saku[day].ajd = toji[3];
        saku[day].sun = 270;
        int[] mid = new int[]{new Span(toji[0], toji[1]).getDayPart() + 1, new Span(toji[0], toji[2]).getDayPart() + 1};
        saku[mid[0]].ajd = toji[1];
        saku[mid[0]].sun = 270;
        saku[mid[1]].ajd = toji[2];
        saku[mid[1]].sun = 270;
        ajd = ajd.trim();
        saku[0].moon = Equinox.getMoonPhase(toji[0]);
        day = 1;
        while (day < saku.length) {
            int sub;
            saku[day].ajd = toji[0].addDay(day);
            saku[day].moon = Equinox.getMoonPhase(saku[day].ajd);
            int pre = day - 1;
            if (saku[pre].moon == null) {
                ++day;
                continue;
            }
            if (saku[day].moon.compareTo(saku[pre].moon) < 0) {
                if (saku[day].moon.compareTo(BigDecimal.ZERO) == 0) {
                    saku[day].start_f = true;
                    saku[day].sun = LunisolarYear.getSun(saku[day].ajd);
                    pre = day;
                } else {
                    saku[pre].start_f = true;
                    saku[pre].sun = LunisolarYear.getSun(saku[pre].ajd);
                }
                for (int i4 = 0; i4 < mid.length; ++i4) {
                    if (mid[i4] != pre) continue;
                    int n = i4;
                    mid[n] = mid[n] + 1;
                    break;
                }
            }
            if ((sub = 27 - (int)AJD.cut(saku[day].moon)) < 1) {
                sub = 1;
            }
            day += sub;
        }
        Saku[][] line = new Saku[][]{LunisolarYear.countMon(year - 1 == 0 ? -1 : year - 1, saku, 0, mid[0]), LunisolarYear.countMon(year, saku, mid[0], mid[1]), LunisolarYear.countMon(year + 1 == 0 ? 1 : year + 1, saku, mid[1], saku.length - 1)};
        ArrayList<Saku> list = new ArrayList<Saku>();
        for (i = 0; i < line[0].length; ++i) {
            if (line[0][i].year != year) continue;
            list.add(line[0][i]);
        }
        if (saku[mid[0]].start_f) {
            saku[mid[0]].year = year;
            saku[mid[0]].mon = 11;
            list.add(saku[mid[0]]);
        }
        for (i = 0; i < line[1].length; ++i) {
            list.add(line[1][i]);
        }
        if (saku[mid[1]].start_f) {
            saku[mid[1]].year = year;
            saku[mid[1]].mon = 11;
            list.add(saku[mid[1]]);
        }
        for (i = 0; i < line[2].length && line[2][i].year == year; ++i) {
            list.add(line[2][i]);
        }
        int cnt = list.size();
        for (int i5 = 1; i5 < cnt; ++i5) {
            Saku s = (Saku)list.get(i5 - 1);
            if (s.ajd.compareTo(ajd) > 0 || list.get((int)i5).ajd.compareTo(ajd) <= 0) continue;
            year = s.year;
            break;
        }
        LunisolarYear ls = new LunisolarYear(year, list);
        map.put(year, ls);
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LunisolarYear getLunisolarYear(AJD hint) {
        int year = hint.getYear() - 1;
        if (year == 0) {
            year = -1;
        }
        HashMap<Integer, LunisolarYear> hashMap = map;
        synchronized (hashMap) {
            int i = 0;
            while (i < 3) {
                LunisolarYear y;
                if (year == 0) {
                    ++year;
                }
                if ((y = map.get(year)) != null && y.getLSCD(hint) != null) {
                    return y;
                }
                ++i;
                ++year;
            }
            return LunisolarYear.get11(hint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LunisolarYear getLunisolarYear(int year) throws AJDException {
        HashMap<Integer, LunisolarYear> hashMap = map;
        synchronized (hashMap) {
            LunisolarYear y = map.get(year);
            if (y != null) {
                return y;
            }
            return LunisolarYear.get11(new AJD(year, 6, 1));
        }
    }

    private LunisolarYear(int y, ArrayList<Saku> list) {
        int start;
        this.yy = y;
        int cnt = list.size();
        ArrayList<Saku> mine = new ArrayList<Saku>();
        for (start = 0; start < cnt && list.get((int)start).year != y; ++start) {
        }
        while (start < cnt) {
            Saku s = list.get(start);
            if (s.year != y) {
                this.limit = s;
                break;
            }
            mine.add(s);
            ++start;
        }
        this.month = mine.toArray(new Saku[0]);
    }

    public int getYear() {
        return this.yy;
    }

    public LSCD getLSCD(AJD dd) {
        int i;
        AJD ajd = dd.trim();
        if (ajd.compareTo(this.month[0].ajd) < 0) {
            return null;
        }
        if (ajd.compareTo(this.limit.ajd) >= 0) {
            return null;
        }
        for (i = 1; i < this.month.length && ajd.compareTo(this.month[i].ajd) >= 0; ++i) {
        }
        return new LSCD(this.month[i - 1].year, this.month[i - 1].leap_f, this.month[i - 1].mon, this.month[i - 1].ajd, dd);
    }

    public int getMonthCount() {
        return this.month.length;
    }

    public int getLeapMonth() {
        for (int i = 0; i < this.month.length; ++i) {
            if (!this.month[i].leap_f) continue;
            return this.month[i].mon;
        }
        return -1;
    }

    private Saku[] getSaku(int mm, boolean leap_f) throws AJDException {
        for (int i = 0; i < this.month.length; ++i) {
            if (this.month[i].leap_f != leap_f || this.month[i].mon != mm) continue;
            Saku next = i == this.month.length - 1 ? this.limit : this.month[i + 1];
            return new Saku[]{this.month[i], next};
        }
        throw new AJDException("\u6307\u5b9a\u6708\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
    }

    public int getLastDay(int mm, boolean leap_f) throws AJDException {
        Saku[] mon = this.getSaku(mm, leap_f);
        return new Span(mon[0].ajd, mon[1].ajd).getDayPart();
    }

    public LSCD getLSCD(int mm, boolean leap_f, int dd) throws AJDException {
        return this.getLSCD(mm, leap_f, dd, 0, 0, 0);
    }

    public LSCD getLSCD(int mm, boolean leap_f, int dd, int hh, int mi, int ss) throws AJDException {
        int last = this.getLastDay(mm, leap_f);
        if (dd < 1 || dd > this.getLastDay(mm, leap_f)) {
            throw new AJDException("\u6307\u5b9a\u65e5\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        Saku[] mon = this.getSaku(mm, leap_f);
        return new LSCD(this.yy, leap_f, mm, dd, mon[0].ajd.addDay(dd - 1).addHour(hh).addMinute(mi).addSecond(ss));
    }

    public String toString() {
        return Integer.toString(this.yy);
    }

    @Override
    public int compareTo(LunisolarYear y) {
        int ret = this.yy - y.yy;
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.yy;
    }

    public boolean equals(Object o) {
        if (o instanceof LunisolarYear) {
            return this.yy == ((LunisolarYear)o).yy;
        }
        return false;
    }
}

