/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.file;

import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAbstractFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.SelectQuery;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.mail.Header;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALFileLocalFolder
extends ALAbstractFolder {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALFileLocalFolder.class.getName());
    public static final String DEFAULT_MAIL_FILENAME_DATE_FORMAT = "yyyyMMddHHmmssSSS";

    public ALFileLocalFolder(int type_mail, String org_id, int user_id, int account_id) {
        super(type_mail, org_id, user_id, account_id);
    }

    @Override
    public ALLocalMailMessage getMail(int mailid) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            EipTMail email = (EipTMail)query.setQualifier(exp1.andExp(exp2)).fetchSingle();
            if (email == null) {
                logger.debug((Object)"[Mail] Not found ID...");
                return null;
            }
            ALLocalMailMessage msg = this.readMail(this.getFullName() + File.separator + email.getFilePath());
            email.setReadFlg("T");
            Database.commit();
            return msg;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return null;
        }
    }

    private ALLocalMailMessage readMail(String filepath) {
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        System.setProperty("mail.mime.decodetext.strict", "false");
        Properties prop = new Properties();
        prop.setProperty("mail.mime.address.strict", "false");
        ALLocalMailMessage localmsg = null;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(filepath));
            localmsg = new ALLocalMailMessage(Session.getDefaultInstance((Properties)prop), input);
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return localmsg;
    }

    @Override
    public boolean saveMail(ALMailMessage mail, String orgId) {
        boolean res = false;
        try {
            String tmpFileName = this.getNewFileName();
            res = this.saveMailToFile(mail, tmpFileName, true);
            if (res) {
                DataContext dataContext = null;
                dataContext = orgId == null || "".equals(orgId) ? DatabaseOrmService.getInstance().getDataContext() : DataContext.createDataContext((String)orgId);
                res = this.insertMailToDB(dataContext, (MimeMessage)mail, tmpFileName, false, false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    @Override
    public boolean saveDefectiveMail(ALMailMessage mail, String orgId) {
        boolean res = false;
        try {
            String tmpFileName = this.getNewFileName();
            res = this.saveMailToFile(mail, tmpFileName, false);
            if (res) {
                DataContext dataContext = null;
                dataContext = orgId == null || "".equals(orgId) ? DatabaseOrmService.getInstance().getDataContext() : DataContext.createDataContext((String)orgId);
                res = this.insertMailToDB(dataContext, (MimeMessage)mail, tmpFileName, false, false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMailToFile(ALMailMessage mail, String fileName, boolean savecontents) {
        boolean res = false;
        FilterOutputStream output = null;
        try {
            String pop3MailPath = this.getFullName() + File.separator + fileName;
            output = new BufferedOutputStream(new FileOutputStream(pop3MailPath));
            if (savecontents) {
                mail.writeTo(output);
            } else {
                MimeMessage mimeMessage = (MimeMessage)mail;
                Session session = Session.getDefaultInstance((Properties)new Properties());
                MimeMessage newMsg = new MimeMessage(session);
                Enumeration headers = mimeMessage.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header h = (Header)headers.nextElement();
                    newMsg.addHeader(h.getName(), h.getValue());
                }
                newMsg.setText("\u30e1\u30fc\u30eb\u306e\u30b5\u30a4\u30ba\u304c7MB\u3092\u8d85\u3048\u3066\u3044\u305f\u305f\u3081\u3001\u3053\u306e\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\r\n \u8aa0\u306b\u6050\u308c\u5165\u308a\u307e\u3059\u304c\u3001\u5225\u306e\u30e1\u30fc\u30e9\u30fc\u3067\u53d7\u4fe1\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                newMsg.writeTo((OutputStream)output);
            }
            ((BufferedOutputStream)output).flush();
            output.close();
            mail.clearContents();
            res = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"Exception", (Throwable)ie);
            }
            res = false;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"Exception", (Throwable)ie);
                res = false;
            }
        }
        return res;
    }

    @Override
    public boolean deleteMail(int mailid) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            Expression exp3 = ExpressionFactory.matchExp((String)"accountId", (Object)this.account_id);
            List mail_list = query.andQualifier(exp1).andQualifier(exp2).andQualifier(exp3).fetchList();
            if (mail_list == null || mail_list.size() == 0) {
                logger.debug((Object)"[ALDbLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTMail record = (EipTMail)mail_list.get(0);
            String filePath = record.getFilePath();
            File file = new File(this.getFullName() + File.separator + filePath);
            if (file.exists()) {
                file.delete();
            }
            Database.delete((Persistent)record);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMails(List<String> msgIndexes) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"MAIL_ID", msgIndexes);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            List mail_list = query.andQualifier(exp1).andQualifier(exp2).fetchList();
            if (mail_list == null || mail_list.size() == 0) {
                logger.debug((Object)"[ALFileLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            for (EipTMail record : mail_list) {
                String filePath = record.getFilePath();
                File file = new File(this.getFullName() + File.separator + filePath);
                if (!file.exists()) continue;
                file.delete();
            }
            Database.deleteAll((List)mail_list);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    @Override
    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("read_flg", "readFlg");
        map.putValue("subject", "subject");
        map.putValue("person", "person");
        map.putValue("date", "eventDate");
        map.putValue("volume", "fileVolume");
        return map;
    }

    @Override
    public int getNewMailNum() {
        return 0;
    }

    @Override
    public void setNewMailNum(int num) {
    }

    public int getMailSum() {
        return 0;
    }

    @Override
    public int getUnreadMailNum() {
        return 0;
    }

    @Override
    public void close() {
    }

    public String getNewFileName() {
        int count = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_MAIL_FILENAME_DATE_FORMAT);
        Date date = new Date();
        String tmpname = simpleDateFormat.format(date);
        String pop3MailPath = this.getFullName() + File.separator;
        File file = null;
        String newFileName = null;
        String newFilePath = null;
        while (true) {
            newFileName = tmpname + count;
            newFilePath = pop3MailPath + newFileName;
            file = new File(newFilePath);
            if (!file.exists()) break;
            ++count;
        }
        return newFileName;
    }
}

