/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALMailHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALMailHandler.class.getName());

    public int receive(ALMailReceiverContext rcontext, String orgId) throws Exception {
        int result = -1;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver.receive(orgId);
        }
        catch (Exception e) {
            result = -1;
            logger.error((Object)"Exception", (Throwable)e);
        }
        return result;
    }

    protected abstract ALMailReceiver getALMailReceiver(ALMailReceiverContext var1);

    public int send(ALMailSenderContext scontext, ALMailContext mcontext) throws Exception {
        int result = 0;
        try {
            ALMailSender sender = this.getALMailSender(scontext);
            result = sender.send(mcontext);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            result = 1;
        }
        return result;
    }

    protected abstract ALMailSender getALMailSender(ALMailSenderContext var1);

    public abstract ALFolder getALFolder(int var1, String var2, int var3, int var4);

    private SelectQuery<EipTMail> getUnReadMailQuery(ALMailReceiverContext rcontext, List<Integer> foler_ids) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)rcontext.getUserId());
            Expression exp2 = ExpressionFactory.matchExp((String)"accountId", (Object)rcontext.getAccountId());
            Expression exp3 = ExpressionFactory.matchExp((String)"type", (Object)"R");
            Expression exp4 = ExpressionFactory.matchExp((String)"readFlg", (Object)"F");
            query.setQualifier(exp1.andExp(exp2).andExp(exp3).andExp(exp4));
            if (foler_ids != null && foler_ids.size() > 0) {
                Expression exp5 = ExpressionFactory.inExp((String)"folderId", foler_ids);
                query.andQualifier(exp5);
            }
            return query;
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return null;
        }
    }

    public int getUnReadMailSum(ALMailReceiverContext rcontext) {
        try {
            SelectQuery<EipTMail> query = this.getUnReadMailQuery(rcontext, null);
            query.select("MAIL_ID");
            return query.getCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Map<Integer, Integer> getUnReadMailSumMap(ALMailReceiverContext rcontext) {
        HashMap<Integer, Integer> mailSumMap = new HashMap<Integer, Integer>();
        try {
            EipMMailAccount account = ALMailUtils.getMailAccount(rcontext.getOrgId(), rcontext.getUserId(), rcontext.getAccountId());
            List<EipTMailFolder> folders = ALMailUtils.getEipTMailFolderAll(account);
            ArrayList<Integer> folder_ids = new ArrayList<Integer>();
            for (EipTMailFolder folder : folders) {
                int folder_id = folder.getFolderId();
                folder_ids.add(folder_id);
                mailSumMap.put(folder_id, 0);
            }
            Iterator i$ = folder_ids.iterator();
            while (i$.hasNext()) {
                int _foler_id = (Integer)i$.next();
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(_foler_id);
                SelectQuery<EipTMail> countquery = this.getUnReadMailQuery(rcontext, list);
                int count = countquery.orderAscending("folderId").getCount();
                mailSumMap.put(_foler_id, count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mailSumMap;
    }

    public int getNewMailSum(ALMailReceiverContext rcontext) throws Exception {
        int result = -1;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver != null ? receiver.getNewMailSum() : -1;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            result = -1;
        }
        return result;
    }

    public abstract boolean removeAccount(String var1, int var2, int var3);
}

