/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.util.ALAttachmentsExtractor;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.orgutils.ALOrgUtilsFactoryService;
import com.aimluck.eip.util.orgutils.ALOrgUtilsHandler;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.MultipartUtility;
import com.sk_jp.mail.PartHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALAbstractFolder
implements ALFolder {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALAbstractFolder.class.getName());
    protected int type_mail = -1;
    protected String org_id;
    protected int user_id;
    protected int account_id;
    protected String rootFolderPath = null;
    protected String categoryKey = null;
    private int rows_num = 10;
    private int strlen = 0;
    private int start;
    private int count;
    private int pages_num = 1;
    private int current_page = 1;
    private String current_sort;
    private String current_sort_type;
    protected final String LIST_SORT_STR = new StringBuffer().append(this.getClass().getName()).append("sort").toString();
    protected final String LIST_SORT_TYPE_STR = new StringBuffer().append(this.getClass().getName()).append("sorttype").toString();

    public ALAbstractFolder(int type_mail, String org_id, int user_id, int account_id) {
        this.type_mail = type_mail;
        this.org_id = org_id;
        this.user_id = user_id;
        this.account_id = account_id;
    }

    protected void init(RunData rundata, Context context) {
        if (rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)rundata.getParameters().getString("sort"));
        }
        if (rundata.getParameters().containsKey((Object)"sorttype")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)rundata.getParameters().getString("sorttype"));
        }
        if (rundata.getParameters().containsKey((Object)"start")) {
            this.current_page = rundata.getParameters().getInt("start");
        }
    }

    protected boolean insertMailToDB(DataContext dataContext, MimeMessage mimeMessage, String filePath, boolean saveContents, boolean isRead) {
        try {
            String preson;
            Address[] receiveAddress;
            Address[] presonAddress;
            String type0;
            EipTMail email = (EipTMail)Database.create((DataContext)dataContext, EipTMail.class);
            if (saveContents) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                mimeMessage.writeTo((OutputStream)output);
            } else {
                Session session = Session.getDefaultInstance((Properties)new Properties());
                MimeMessage newMsg = new MimeMessage(session);
                Enumeration headers = mimeMessage.getAllHeaders();
                while (headers.hasMoreElements()) {
                    Header h = (Header)headers.nextElement();
                    newMsg.addHeader(h.getName(), h.getValue());
                }
                newMsg.setText("\u30e1\u30fc\u30eb\u306e\u30b5\u30a4\u30ba\u304c7MB\u3092\u8d85\u3048\u3066\u3044\u305f\u305f\u3081\u3001\u3053\u306e\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\r\n \u8aa0\u306b\u6050\u308c\u5165\u308a\u307e\u3059\u304c\u3001\u5225\u306e\u30e1\u30fc\u30e9\u30fc\u3067\u53d7\u4fe1\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                newMsg.writeTo((OutputStream)output);
            }
            Date sentDate = null;
            String subject = mimeMessage.getHeader("Subject", null);
            if (subject == null) {
                subject = MailUtility.encodeWordJIS((String)"\u7121\u984c");
            } else {
                subject = subject.replaceAll("\r", "");
                subject = subject.replaceAll("\n", "");
            }
            String string = type0 = 1 == this.type_mail ? "R" : "S";
            if ("R".equals(type0)) {
                try {
                    presonAddress = mimeMessage.getFrom();
                }
                catch (MessagingException ex) {
                    presonAddress = null;
                }
            } else {
                try {
                    presonAddress = mimeMessage.getAllRecipients();
                }
                catch (MessagingException ex) {
                    presonAddress = null;
                }
            }
            try {
                receiveAddress = mimeMessage.getAllRecipients();
            }
            catch (MessagingException ex) {
                receiveAddress = null;
            }
            if (presonAddress != null && presonAddress.length > 0) {
                String personaladdr = ALMailUtils.getOneString(ALMailUtils.getTokens(presonAddress[0].toString(), ALMailUtils.CR), "");
                try {
                    preson = MailUtility.decodeText((String)personaladdr);
                    if (presonAddress.length > 1) {
                        preson = preson + "\uff0c...";
                    }
                }
                catch (RuntimeException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                    preson = "--";
                }
            } else {
                preson = "--";
            }
            try {
                sentDate = mimeMessage.getSentDate();
            }
            catch (MessagingException ex) {
                // empty catch block
            }
            if (sentDate == null) {
                sentDate = Calendar.getInstance().getTime();
            }
            int fileVolume = 0;
            try {
                fileVolume = (int)Math.ceil((double)mimeMessage.getSize() / 1024.0);
            }
            catch (MessagingException ex) {
                fileVolume = 0;
            }
            String hasAttachments = null;
            if (saveContents) {
                try {
                    ALAttachmentsExtractor h = new ALAttachmentsExtractor();
                    MultipartUtility.process((Part)mimeMessage, (PartHandler)h);
                    hasAttachments = h.getCount() > 0 ? "T" : "F";
                }
                catch (MessagingException ex) {
                    hasAttachments = "F";
                }
            } else {
                hasAttachments = "F";
            }
            String type = 1 == this.type_mail ? "R" : "S";
            String read_flg = isRead ? "T" : "F";
            EipMMailAccount account = ALMailUtils.getMailAccount(this.org_id, this.user_id, this.account_id);
            int folder_id = account.getDefaultFolderId();
            List<EipTMailFilter> filters = ALMailUtils.getEipTMailFilters(account);
            if (filters != null) {
                for (EipTMailFilter mailFilter : filters) {
                    if (!ALMailUtils.isMatchFilter(mailFilter, subject, preson, receiveAddress)) continue;
                    folder_id = mailFilter.getEipTMailFolder().getFolderId();
                    break;
                }
            }
            email.setUserId(Integer.valueOf(this.user_id));
            email.setAccountId(Integer.valueOf(this.account_id));
            email.setType(type);
            email.setReadFlg(read_flg);
            email.setSubject(subject);
            email.setPerson(preson);
            email.setEventDate(sentDate);
            email.setFileVolume(Integer.valueOf(fileVolume));
            email.setHasFiles(hasAttachments);
            email.setFilePath(filePath);
            email.setFolderId(Integer.valueOf(folder_id));
            email.setCreateDate(Calendar.getInstance().getTime());
            email.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit((DataContext)dataContext);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    @Override
    public ResultList<EipTMail> getIndexRows(RunData rundata, Context context) throws Exception {
        try {
            String sort_type;
            String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
            if (sort == null || sort.equals("")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
            }
            this.init(rundata, context);
            if ("date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && ((sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR)) == null || sort_type.equals(""))) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
            }
            SelectQuery<EipTMail> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList resultList = query.getResultList();
            this.setPageParam(resultList.getTotalCount());
            return resultList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTMail> getSelectQuery(RunData rundata, Context context) {
        String type = this.type_mail == 1 ? "R" : "S";
        String folder_id = "";
        if (this.type_mail == 1) {
            folder_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folderid");
        }
        SelectQuery query = Database.query(EipTMail.class);
        query.select("MAIL_ID");
        query.select("READ_FLG");
        query.select("SUBJECT");
        query.select("PERSON");
        query.select("EVENT_DATE");
        query.select("FILE_VOLUME");
        query.select("HAS_FILES");
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"accountId", (Object)this.account_id);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchExp((String)"type", (Object)type);
        query.andQualifier(exp3);
        if (!"".equals(folder_id)) {
            Expression exp4 = ExpressionFactory.matchExp((String)"folderId", (Object)Integer.valueOf(folder_id));
            query.andQualifier(exp4);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> loadUID() {
        ArrayList<String> oldUIDL = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String indexFilename = this.getFullName() + File.separator + "uid.dat";
            File uidlFile = new File(indexFilename);
            if (!uidlFile.exists()) {
                uidlFile.createNewFile();
                uidlFile = new File(indexFilename);
                if (!uidlFile.exists()) {
                    ArrayList<String> arrayList = oldUIDL;
                    return arrayList;
                }
            }
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(uidlFile)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                oldUIDL.add(line);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        return oldUIDL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUID(List<String> oldUIDL) {
        PrintWriter writer = null;
        try {
            String uidlFilename = this.getFullName() + File.separator + "uid.dat";
            File file = new File(uidlFilename);
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new PrintWriter(new FileOutputStream(new File(uidlFilename)));
            int length = oldUIDL.size();
            for (int i = 0; i < length; ++i) {
                writer.println(oldUIDL.get(i));
            }
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public void setRootFolderPath(String str) {
        this.rootFolderPath = str;
    }

    protected String getRootFolderPath() {
        return this.rootFolderPath != null && !"".equals(this.rootFolderPath) ? this.rootFolderPath : ALMailUtils.rootFolderPath;
    }

    protected String getCategoryKey() {
        return this.categoryKey != null && !"".equals(this.categoryKey) ? this.categoryKey : ALMailUtils.categoryKey;
    }

    @Override
    public String getFullName() {
        StringBuffer fullName = null;
        String categoryKeytmp = this.getCategoryKey();
        if (categoryKeytmp != null && !"".equals(categoryKeytmp)) {
            ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
            File docPath = handler.getDocumentPath(this.getRootFolderPath(), this.org_id, categoryKeytmp);
            String pathStr = null;
            try {
                pathStr = docPath.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Object)("ALAbstractFolder: unable to resolve file path for " + pathStr));
            }
            fullName = new StringBuffer(pathStr);
            fullName.append(File.separator).append(this.user_id).append(File.separator).append(this.account_id);
        } else {
            fullName = new StringBuffer(this.getRootFolderPath());
            fullName.append(File.separator).append(this.org_id).append(File.separator).append(this.user_id).append(File.separator).append(this.account_id);
        }
        if (1 == this.type_mail) {
            fullName.append(File.separator).append("Receive");
        } else {
            fullName.append(File.separator).append("Send");
        }
        String path = fullName.toString();
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return fullName.toString();
    }

    protected void buildSelectQueryForListView(SelectQuery<EipTMail> query) {
        query.limit(this.getRowsNum());
        query.page(this.current_page);
    }

    @Deprecated
    protected List<EipTMail> buildPaginatedList(List<EipTMail> records) {
        ArrayList<EipTMail> list = new ArrayList<EipTMail>();
        this.setPageParam(records.size());
        int size = records.size();
        int end = this.start + this.rows_num <= size ? this.start + this.rows_num : size;
        for (int i = this.start; i < end; ++i) {
            list.add(records.get(i));
        }
        return list;
    }

    protected void setPageParam(int cnt) {
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
        this.current_page = this.current_page <= this.pages_num ? this.current_page : this.pages_num;
        this.start = this.rows_num * (this.current_page > 0 ? this.current_page - 1 : this.current_page);
    }

    protected SelectQuery<EipTMail> buildSelectQueryForListViewSort(SelectQuery<EipTMail> query, RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort == null) {
            return query;
        }
        crt_key = map.getValue(sort);
        if (crt_key == null) {
            return query;
        }
        if (sort_type != null && "desc".equals(sort_type)) {
            query.orderDesending(crt_key);
        } else {
            query.orderAscending(crt_key);
            sort_type = "asc";
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        return query;
    }

    @Override
    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public void setStrLength(int num) {
        if (num >= 0) {
            this.strlen = num;
        }
    }

    @Override
    public int getStrLength() {
        return this.strlen;
    }

    @Override
    public int getRowsNum() {
        return this.rows_num;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getPagesNum() {
        return this.pages_num;
    }

    @Override
    public int getCurrentPage() {
        return this.current_page;
    }

    @Override
    public String getCurrentSort() {
        return this.current_sort;
    }

    @Override
    public String getCurrentSortType() {
        return this.current_sort_type;
    }

    protected abstract Attributes getColumnMap();

    @Override
    public int getStart() {
        return this.start;
    }
}

