/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow.util;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowFile;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.orgutils.ALOrgUtilsFactoryService;
import com.aimluck.eip.util.orgutils.ALOrgUtilsHandler;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowDecisionRecordData;
import com.aimluck.eip.workflow.WorkflowDetailResultData;
import com.aimluck.eip.workflow.WorkflowOldRequestResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.beans.WorkflowMailBean;
import java.io.File;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowUtils.class.getName());
    public static final String DB_STATUS_REQUEST = "R";
    public static final String DB_STATUS_CONFIRM = "C";
    public static final String DB_STATUS_WAIT = "W";
    public static final String DB_STATUS_ACCEPT = "A";
    public static final String DB_STATUS_DENIAL = "D";
    public static final String DB_STATUS_THROUGH = "T";
    public static final String DB_PROGRESS_ACCEPT = "A";
    public static final String DB_PROGRESS_WAIT = "W";
    public static final String DB_PROGRESS_DENAIL = "D";
    public static final String DB_PROGRESS_REAPPLY = "R";
    public static final String KEY_COMPLETE = "COMPLETE";
    public static final String KEY_APPROVE = "APPROVE";
    public static final String KEY_PASSBACK = "PASSBACK";
    public static final String PREFIX_DBFILE = "DBF";
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    private static final String FOLDER_FILEDIR_WORKFLOW = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    protected static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.workflow.categorykey", (String)"");

    public static EipTWorkflowRequest getEipTWorkflowRequest(RunData rundata, Context context, boolean mode_update) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            List requests;
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query10 = Database.query(EipTWorkflowRequestMap.class);
            Expression exp10 = ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest.REQUEST_ID", (Object)Integer.valueOf(requestid));
            Expression exp11 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
            query10.setQualifier(exp10.andExp(exp11));
            List maps = query10.fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkFlow] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            if (mode_update) {
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)DB_STATUS_CONFIRM);
                query.andQualifier(exp3);
                Expression exp4 = ExpressionFactory.matchExp((String)"progress", (Object)"W");
                query.andQualifier(exp4);
            }
            if ((requests = query.fetchList()) == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (ALPageNotFoundException pageNotFound) {
            logger.error((Object)pageNotFound);
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestAll(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            WhatsNewUtils.shiftWhatsNewReadFlag((int)3, (int)Integer.parseInt(requestid), (int)ALEipUtils.getUserId((RunData)rundata));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRequest getEipTWorkflowRequestForOwner(RunData rundata, Context context) {
        String requestid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (requestid == null || Integer.valueOf(requestid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRequest)requests.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowFile getEipTWorkflowFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTWorkflowFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTWorkflowFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[WorkflowUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTWorkflowRequestMap> getEipTWorkflowRequestMap(EipTWorkflowRequest request) {
        try {
            SelectQuery query = Database.query(EipTWorkflowRequestMap.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest.REQUEST_ID", (Object)request.getRequestId());
            query.setQualifier(exp);
            query.orderAscending("orderIndex");
            List maps = query.fetchList();
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return maps;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(RunData rundata, Context context) {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (categoryid == null || Integer.valueOf(categoryid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryid);
            query.setQualifier(exp1);
            List categories = query.fetchList();
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowCategory getEipTWorkflowCategory(Long category_id) {
        try {
            EipTWorkflowCategory category = (EipTWorkflowCategory)Database.get(EipTWorkflowCategory.class, (Object)category_id);
            return category;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<WorkflowCategoryResultData> loadCategoryList(RunData rundata, Context context) {
        try {
            ArrayList<WorkflowCategoryResultData> categoryList = new ArrayList<WorkflowCategoryResultData>();
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            List aList = query.fetchList();
            for (EipTWorkflowCategory record : aList) {
                WorkflowCategoryResultData rd = new WorkflowCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                rd.setOrderTemplate(record.getTemplate());
                categoryList.add(rd);
            }
            return categoryList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRoute getEipTWorkflowRoute(RunData rundata, Context context) {
        String routeid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (routeid == null || Integer.valueOf(routeid) == null) {
                logger.debug((Object)"[WorkflowUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROUTE_ID", (Object)routeid);
            query.setQualifier(exp1);
            List routes = query.fetchList();
            if (routes == null || routes.size() == 0) {
                logger.debug((Object)"[WorkflowUtils] Not found ID...");
                return null;
            }
            return (EipTWorkflowRoute)routes.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTWorkflowRoute getEipTWorkflowRoute(Long route_id) {
        try {
            EipTWorkflowRoute route = (EipTWorkflowRoute)Database.get(EipTWorkflowRoute.class, (Object)route_id);
            return route;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<WorkflowRouteResultData> loadRouteList(RunData rundata, Context context) {
        try {
            ArrayList<WorkflowRouteResultData> routeList = new ArrayList<WorkflowRouteResultData>();
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            query.orderAscending("routeName");
            List aList = query.fetchList();
            for (EipTWorkflowRoute record : aList) {
                WorkflowRouteResultData rd = new WorkflowRouteResultData();
                rd.initField();
                rd.setRouteId(record.getRouteId().longValue());
                rd.setRouteName(record.getRouteName());
                rd.setRoute(record.getRoute());
                routeList.add(rd);
            }
            return routeList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Object getResultDataDetail(Object obj, ALEipUser login_user) {
        try {
            List list;
            List<EipTWorkflowRequest> oldReuqests;
            EipTWorkflowRequest record = (EipTWorkflowRequest)obj;
            WorkflowDetailResultData rd = new WorkflowDetailResultData();
            rd.initField();
            rd.setUserId(record.getUserId().longValue());
            rd.setRequestName(record.getRequestName());
            rd.setRequestId(record.getRequestId().longValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTWorkflowCategory().getCategoryName());
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setPrice(record.getPrice());
            rd.setProgress(record.getProgress());
            rd.setCanRemandApplicant(true);
            if (record.getEipTWorkflowRoute() != null) {
                rd.setRouteName(record.getEipTWorkflowRoute().getRouteName());
            }
            ArrayList<WorkflowDecisionRecordData> drList = new ArrayList<WorkflowDecisionRecordData>();
            ArrayList<WorkflowDecisionRecordData> remandList = new ArrayList<WorkflowDecisionRecordData>();
            ALEipUser user = null;
            EipTWorkflowRequestMap map = null;
            WorkflowDecisionRecordData drd = null;
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            boolean is_past = true;
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                drd = new WorkflowDecisionRecordData();
                drd.initField();
                if (login_user.getUserId().getValue() == map.getUserId().longValue()) {
                    is_past = false;
                }
                user = ALEipUtils.getALEipUser((int)map.getUserId());
                drd.setUserId(map.getUserId().intValue());
                drd.setUserAliasName(user.getAliasName().getValue());
                drd.setStatus(map.getStatus());
                drd.setStatusString(WorkflowUtils.getStatusString(map.getStatus()));
                drd.setOrder(map.getOrderIndex());
                drd.setNote(map.getNote());
                drd.setUpdateDate(WorkflowUtils.translateDate(map.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
                drList.add(drd);
                if (is_past && !WorkflowUtils.isDisabledOrDeleted(map.getUserId())) {
                    remandList.add(drd);
                    continue;
                }
                if (i != 0) continue;
                rd.setCanRemandApplicant(false);
            }
            rd.setDecisionRecords(drList);
            rd.setRemandingRecords(remandList);
            if (record.getParentId() != 0 && (oldReuqests = WorkflowUtils.getOldRequests(record)) != null && oldReuqests.size() > 0) {
                ArrayList<WorkflowOldRequestResultData> oldList = new ArrayList<WorkflowOldRequestResultData>();
                int osize = oldReuqests.size();
                for (int i = 0; i < osize; ++i) {
                    EipTWorkflowRequest request = oldReuqests.get(i);
                    WorkflowOldRequestResultData orrd = new WorkflowOldRequestResultData();
                    orrd.initField();
                    orrd.setRequestId(request.getRequestId().intValue());
                    orrd.setRequestName(request.getRequestName());
                    orrd.setCategoryName(request.getEipTWorkflowCategory().getCategoryName());
                    orrd.setUpdateDate(WorkflowUtils.translateDate(request.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
                    oldList.add(orrd);
                }
                rd.setOldRequestLinks(oldList);
            }
            if ((list = WorkflowUtils.getSelectQueryForFiles(record.getRequestId()).fetchList()) != null && list.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                for (EipTWorkflowFile file : list) {
                    String realname = file.getFileName();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            rd.setUpdateDate(WorkflowUtils.translateDate(record.getUpdateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private static List<EipTWorkflowRequest> getOldRequests(EipTWorkflowRequest request) {
        try {
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)request.getParentId());
            Expression exp12 = ExpressionFactory.matchExp((String)"parentId", (Object)request.getParentId());
            query.setQualifier(exp11.orExp(exp12));
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"REQUEST_ID", (Object)request.getRequestId());
            query.andQualifier(exp2);
            query.orderAscending("updateDate");
            List requests = query.fetchList();
            if (requests == null || requests.size() == 0) {
                logger.debug((Object)"[WorkflowSelectData] Not found ID...");
                return null;
            }
            return requests;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getPriorityImage(int i) {
        String[] temp = new String[]{"priority_high.gif", "priority_middle_high.gif", "priority_middle.gif", "priority_middle_low.gif", "priority_low.gif"};
        String image = null;
        try {
            image = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getPriorityString(int i) {
        String[] temp = new String[]{"\u9ad8\u3044", "\u3084\u3084\u9ad8\u3044", "\u666e\u901a", "\u3084\u3084\u4f4e\u3044", "\u4f4e\u3044"};
        String string = null;
        try {
            string = temp[i - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getStateImage(int i) {
        String[] temp = new String[]{"state_000.gif", "state_010.gif", "state_020.gif", "state_030.gif", "state_040.gif", "state_050.gif", "state_060.gif", "state_070.gif", "state_080.gif", "state_090.gif", "state_100.gif"};
        String image = null;
        try {
            image = temp[i / 10];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static String getStateString(int i) {
        if (i == 0) {
            return "\u672a\u7740\u624b";
        }
        if (i == 100) {
            return "\u5b8c\u4e86";
        }
        return new StringBuffer().append(i).append("%").toString();
    }

    public static String getStatusString(String status) {
        String res = "";
        if ("R".equals(status)) {
            res = "\u7533\u8acb";
        } else if (DB_STATUS_CONFIRM.equals(status)) {
            res = "\u78ba\u8a8d\u4e2d";
        } else if ("W".equals(status)) {
            res = "\u78ba\u8a8d\u524d";
        } else if ("A".equals(status)) {
            res = "\u627f\u8a8d";
        } else if ("D".equals(status)) {
            res = "\u5426\u8a8d";
        } else if (DB_STATUS_THROUGH.equals(status)) {
            res = "\u81ea\u52d5\u627f\u8a8d";
        }
        return res;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static String translateMoneyStr(String money) {
        if (money == null || money.length() == 0) {
            return money;
        }
        StringBuffer sb = new StringBuffer();
        int len = money.length();
        int count = len / 3;
        int del = len % 3;
        sb.append(money.substring(0, del));
        if (count > 0) {
            if (len > 3 && del != 0) {
                sb.append(",");
            }
            for (int i = 0; i < count; ++i) {
                sb.append(money.substring(del + 3 * i, del + 3 * i + 3));
                if (i == count - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static boolean sendMail(RunData rundata, EipTWorkflowRequest request, List<ALEipUser> destUsers, List<String> msgList) throws Exception {
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        String subject = "[" + DatabaseOrmService.getInstance().getAlias() + "]\u30ef\u30fc\u30af\u30d5\u30ed\u30fc";
        try {
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.addAll(destUsers);
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            for (ALEipUserAddr member : destMemberList) {
                ArrayList<ALEipUserAddr> destMember = new ArrayList<ALEipUserAddr>();
                destMember.add(member);
                ALMailUtils.sendMailDelegate((String)org_id, (int)ALEipUtils.getUserId((RunData)rundata), destMember, (String)subject, (String)subject, (String)WorkflowUtils.createMsgForPc(rundata, request), (String)WorkflowUtils.createMsgForCellPhone(rundata, request, ((ALEipUserAddr)destMember.get(0)).getUserId()), (int)ALMailUtils.getSendDestType((int)23), msgList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean sendMailForUpdate(RunData rundata, List<EipTWorkflowRequestMap> sendMailMaps, EipTWorkflowRequest request, String flowStatus) {
        DatabaseOrmService instance = DatabaseOrmService.getInstance();
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(instance.getOrgId(rundata));
        mailBean.setSubject("[" + instance.getAlias() + "]\u30ef\u30fc\u30af\u30d5\u30ed\u30fc");
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(instance.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        return WorkflowUtils.sendMailForUpdateCore(sendMailMaps, request, flowStatus, mailBean);
    }

    public static boolean sendMailForUpdateCore(List<EipTWorkflowRequestMap> sendMailMaps, EipTWorkflowRequest request, String flowStatus, WorkflowMailBean mailBean) {
        ArrayList msgList = new ArrayList();
        ArrayList<ALEipUserAddr> userAddressList = new ArrayList<ALEipUserAddr>();
        String msgForPcPrefix = WorkflowUtils.createMsgForPcAtUpdatePrefix(request, flowStatus, mailBean);
        String msgForCellPrefix = WorkflowUtils.createMsgForCellAtUpdatePrefix(request, flowStatus, mailBean);
        if ("".equals(msgForPcPrefix) || "".equals(msgForCellPrefix)) {
            return false;
        }
        for (EipTWorkflowRequestMap requestMap : sendMailMaps) {
            userAddressList.add(ALMailUtils.getALEipUserAddrByUserId((int)requestMap.getUserId()));
        }
        try {
            for (ALEipUserAddr userAddr : userAddressList) {
                ALEipUser rcptUser = ALEipUtils.getALEipUser((int)userAddr.getUserId());
                String msgForPc = msgForPcPrefix + WorkflowUtils.createMsgAtUpdateSuffix(rcptUser, false, mailBean);
                String msgForCell = msgForCellPrefix + WorkflowUtils.createMsgAtUpdateSuffix(rcptUser, true, mailBean);
                ALMailUtils.sendMailDelegateOne((String)mailBean.getOrgId(), (int)mailBean.getLoginUserId(), (ALEipUserAddr)userAddr, (String)mailBean.getSubject(), (String)mailBean.getSubject(), (String)msgForPc, (String)msgForCell, (int)ALMailUtils.getSendDestType((int)23), msgList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    public static String createMsgForPcAtUpdatePrefix(EipTWorkflowRequest request, String flowStatus, WorkflowMailBean mailBean) {
        ALEipUser user;
        try {
            user = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (ALDBErrorException e) {
            logger.error((Object)e);
            user = new ALEipUser();
        }
        try {
            StringBuilder body = new StringBuilder("");
            body.append(user.getAliasName().toString());
            body.append(WorkflowUtils.getMessageHead(flowStatus, ALMailUtils.CR));
            body.append(WorkflowUtils.getMessageContent(request, ALMailUtils.CR, false, mailBean));
            return body.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "";
        }
    }

    public static String createMsgForCellAtUpdatePrefix(EipTWorkflowRequest request, String flowStatus, WorkflowMailBean mailBean) {
        ALEipUser user;
        try {
            user = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (ALDBErrorException e) {
            logger.error((Object)e);
            user = new ALEipUser();
        }
        try {
            StringBuilder body = new StringBuilder("");
            body.append(user.getAliasName().toString());
            body.append(WorkflowUtils.getMessageHead(flowStatus, ALMailUtils.CR));
            body.append(WorkflowUtils.getMessageContent(request, ALMailUtils.CR, true, mailBean));
            return body.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "";
        }
    }

    public static String createMsgAtUpdateSuffix(ALEipUser user, boolean isCell, WorkflowMailBean mailBean) {
        return WorkflowUtils.getMessageAipoUri(user, isCell, ALMailUtils.CR, mailBean) + WorkflowUtils.getMessageSignature(ALMailUtils.CR, mailBean);
    }

    public static String getMessageHead(String flowStatus, String CR) throws Exception {
        StringBuilder body = new StringBuilder("");
        if (KEY_COMPLETE.equals(flowStatus)) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u627f\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u627f\u8a8d\u6e08\u307f").append(CR);
        } else if (KEY_APPROVE.equals(flowStatus)) {
            body.append("\u3055\u3093\u304b\u3089\u306e\u627f\u8a8d\u4f9d\u983c\u3067\u3059\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u6c7a\u88c1\u5f85\u3061").append(CR);
        } else if (KEY_PASSBACK.equals(flowStatus)) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u5dee\u3057\u623b\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u5dee\u623b\u8981\u78ba\u8a8d").append(CR);
        } else {
            throw new Exception("unreachable flow exception");
        }
        return body.toString();
    }

    public static String getMessageContent(EipTWorkflowRequest request, String CR, boolean isCell, WorkflowMailBean mailBean) {
        StringBuilder body = new StringBuilder("");
        body.append("[\u8868\u984c]").append(CR);
        body.append(request.getEipTWorkflowCategory().getCategoryName()).append(CR);
        if (request.getRequestName() != null && !"".equals(request.getRequestName())) {
            body.append(request.getRequestName()).append(CR);
        }
        body.append("[\u7533\u8acb\u65e5]").append(CR).append(WorkflowUtils.translateDate(request.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206")).append(CR);
        body.append("[\u91cd\u8981\u5ea6]").append(CR).append(WorkflowUtils.getPriorityString(request.getPriority().intValue())).append(CR);
        if (!isCell) {
            body.append("[\u7533\u8acb\u5185\u5bb9]").append(CR).append(request.getNote()).append(CR);
        }
        if (request.getPrice() != null && request.getPrice().intValue() > 0) {
            body.append("[\u91d1\u984d]").append(CR).append(request.getPrice()).append(" \u5186").append(CR);
        }
        body.append(CR);
        body.append("[").append(mailBean.getAipoAlias()).append("\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        return body.toString();
    }

    public static String getMessageAipoUri(ALEipUser user, boolean isCell, String CR, WorkflowMailBean mailBean) {
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        StringBuilder body = new StringBuilder("");
        if (isCell) {
            body.append(CR);
            body.append("[").append(mailBean.getAipoAlias()).append("\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
            body.append("\u3000").append(mailBean.getGlobalUrl()).append("?key=").append(ALCellularUtils.getCellularKey((ALEipUser)user)).append(CR);
        } else if (enableAsp) {
            body.append("\u3000").append(mailBean.getGlobalUrl()).append(CR);
        } else {
            body.append("\u30fb\u793e\u5916").append(CR);
            body.append("\u3000").append(mailBean.getGlobalUrl()).append(CR);
            body.append("\u30fb\u793e\u5185").append(CR);
            body.append("\u3000").append(mailBean.getLocalUrl()).append(CR).append(CR);
        }
        return body.toString();
    }

    public static String getMessageSignature(String CR, WorkflowMailBean mailBean) {
        StringBuilder body = new StringBuilder("");
        body.append("---------------------").append(CR);
        body.append(mailBean.getAipoAlias()).append(CR);
        return body.toString();
    }

    public static String createMsgForPc(RunData rundata, EipTWorkflowRequest request) {
        String CR = ALMailUtils.CR;
        DatabaseOrmService instance = DatabaseOrmService.getInstance();
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(instance.getOrgId(rundata));
        mailBean.setSubject("[" + instance.getAlias() + "]\u30ef\u30fc\u30af\u30d5\u30ed\u30fc");
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(instance.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        ALBaseUser user = null;
        ALEipUser user2 = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(request.getUserId().toString()));
            user2 = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer body = new StringBuffer("");
        body.append(user2.getAliasName().toString());
        if (!user.getEmail().equals("")) {
            body.append("(").append(user.getEmail()).append(")");
        }
        if ("D".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u5dee\u3057\u623b\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u5dee\u623b\u8981\u78ba\u8a8d").append(CR);
        } else if ("A".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u627f\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u627f\u8a8d\u6e08\u307f").append(CR);
        } else {
            body.append("\u3055\u3093\u304b\u3089\u306e\u627f\u8a8d\u4f9d\u983c\u3067\u3059\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u6c7a\u88c1\u5f85\u3061").append(CR);
        }
        body.append(WorkflowUtils.getMessageContent(request, CR, false, mailBean));
        body.append(WorkflowUtils.createMsgAtUpdateSuffix(user2, false, mailBean));
        return body.toString();
    }

    public static String createMsgForCellPhone(RunData rundata, EipTWorkflowRequest request, int destUserID) {
        String CR = ALMailUtils.CR;
        DatabaseOrmService instance = DatabaseOrmService.getInstance();
        WorkflowMailBean mailBean = new WorkflowMailBean();
        mailBean.setOrgId(instance.getOrgId(rundata));
        mailBean.setSubject("[" + instance.getAlias() + "]\u30ef\u30fc\u30af\u30d5\u30ed\u30fc");
        mailBean.setLoginUserId(ALEipUtils.getUserId((RunData)rundata));
        mailBean.setAipoAlias(instance.getAlias());
        mailBean.setGlobalUrl(ALMailUtils.getGlobalurl());
        mailBean.setLocalUrl(ALMailUtils.getLocalurl());
        ALBaseUser user = null;
        ALEipUser user2 = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(request.getUserId().toString()));
            user2 = ALEipUtils.getALEipUser((int)request.getUserId());
        }
        catch (JetspeedSecurityException e) {
            return "";
        }
        catch (ALDBErrorException e) {
            return "";
        }
        StringBuffer body = new StringBuffer("");
        body.append(user2.getAliasName().toString());
        if (!user.getEmail().equals("")) {
            body.append("(").append(user.getEmail()).append(")");
        }
        if ("D".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u5dee\u3057\u623b\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u5dee\u623b\u8981\u78ba\u8a8d").append(CR);
        } else if ("A".equals(request.getProgress())) {
            body.append("\u3055\u3093\u306e\u7533\u8acb\u306f\u627f\u8a8d\u3055\u308c\u307e\u3057\u305f\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u627f\u8a8d\u6e08\u307f").append(CR);
        } else {
            body.append("\u3055\u3093\u304b\u3089\u306e\u627f\u8a8d\u4f9d\u983c\u3067\u3059\u3002").append(CR).append(CR);
            body.append("[\u6c7a\u88c1\u72b6\u6cc1]").append(CR);
            body.append("\u6c7a\u88c1\u5f85\u3061").append(CR);
        }
        body.append(WorkflowUtils.getMessageContent(request, CR, true, mailBean));
        body.append(WorkflowUtils.createMsgAtUpdateSuffix(user2, true, mailBean));
        return body.toString();
    }

    public static boolean hasWorkFlowAuthority(List<ALEipUser> memberList) {
        int size = memberList.size();
        ArrayList<ALNumberField> userIds = new ArrayList<ALNumberField>();
        for (int i = 0; i < size; ++i) {
            userIds.add(memberList.get(i).getUserId());
        }
        return false;
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTWorkflowRequest request, EipTWorkflowRequest oldrequest, List<FileuploadLiteBean> fileuploadList, String folderName, List<String> msgList) {
        int i;
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return true;
        }
        int fileIDsize = fileids[0].equals("") ? 0 : fileids.length;
        SelectQuery dbquery = Database.query(EipTWorkflowFile.class);
        dbquery.andQualifier(ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest", (Object)request.getRequestId()));
        for (int i2 = 0; i2 < fileIDsize; ++i2) {
            dbquery.orQualifier(ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileids[i2]));
        }
        List files = dbquery.fetchList();
        if (files.size() == fileIDsize && (fileuploadList == null || fileuploadList.size() <= 0)) {
            return true;
        }
        SelectQuery query = Database.query(EipTWorkflowFile.class);
        query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest", (Object)request.getRequestId()));
        for (int i3 = 0; i3 < fileIDsize; ++i3) {
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)Integer.parseInt(fileids[i3]));
            query.andQualifier(exp.notExp());
        }
        List delFiles = query.fetchList();
        if (delFiles.size() > 0) {
            File file = null;
            int delsize = delFiles.size();
            for (i = 0; i < delsize; ++i) {
                file = new File(WorkflowUtils.getSaveDirPath(org_id, uid) + ((EipTWorkflowFile)delFiles.get(i)).getFilePath());
                if (!file.exists()) continue;
                file.delete();
            }
            Database.deleteAll((List)delFiles);
        }
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            FileuploadLiteBean filebean = null;
            int size = fileuploadList.size();
            for (i = 0; i < size; ++i) {
                filebean = fileuploadList.get(i);
                String[] acceptExts = ImageIO.getWriterFormatNames();
                byte[] fileThumbnail = FileuploadUtils.getBytesShrinkFilebean((String)org_id, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, msgList);
                String filename = FileuploadUtils.getNewFileName((String)WorkflowUtils.getSaveDirPath(org_id, uid));
                EipTWorkflowFile file = (EipTWorkflowFile)Database.create(EipTWorkflowFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTWorkflowRequest(request);
                file.setFileName(filebean.getFileName());
                file.setFilePath(WorkflowUtils.getRelativePath(filename));
                if (fileThumbnail != null) {
                    file.setFileThumbnail(fileThumbnail);
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                File srcFile = FileuploadUtils.getAbsolutePath((String)org_id, (int)uid, (String)folderName, (int)filebean.getFileId());
                File destFile = new File(WorkflowUtils.getAbsolutePath(org_id, uid, filename));
                FileuploadUtils.copyFile((File)srcFile, (File)destFile);
                srcFile = null;
                destFile = null;
            }
            File folder = FileuploadUtils.getFolder((String)org_id, (int)uid, (String)folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
        File path = new File(handler.getDocumentPath(FOLDER_FILEDIR_WORKFLOW, orgId, CATEGORY_KEY) + File.separator + uid);
        if (!path.exists()) {
            path.mkdirs();
        }
        return path.getAbsolutePath();
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getAbsolutePath(String orgId, int uid, String fileName) {
        ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
        StringBuffer sb = new StringBuffer().append(handler.getDocumentPath(FOLDER_FILEDIR_WORKFLOW, orgId, CATEGORY_KEY)).append(File.separator).append(uid);
        File f = new File(sb.toString());
        if (!f.exists()) {
            f.mkdirs();
        }
        return sb.append(File.separator).append(fileName).toString();
    }

    public static List<UserLiteBean> getAuthorityUsers(RunData rundata, String groupname, boolean includeLoginuser) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List ulist = aclhandler.getAuthorityUsersFromGroup(rundata, "workflow_request_self", groupname, includeLoginuser);
            ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
            for (TurbineUser tuser : ulist) {
                UserLiteBean user = new UserLiteBean();
                user.initField();
                user.setUserId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                list.add(user);
            }
            return list;
        }
        catch (InstantiationException e) {
            return null;
        }
    }

    private static SelectQuery<EipTWorkflowFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTWorkflowFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
        query.setQualifier(exp);
        return query;
    }

    public static String getName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String firstName = null;
        String lastName = null;
        StringBuffer buffer = new StringBuffer();
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            firstName = ((TurbineUser)destUserList.get(0)).getFirstName();
            lastName = ((TurbineUser)destUserList.get(0)).getLastName();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return buffer.append(lastName).append(" ").append(firstName).toString();
    }

    public static String getUserName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String userName = null;
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userName = ((TurbineUser)destUserList.get(0)).getLoginName();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return userName;
    }

    public static Integer getRouteIdFromCategoryId(Integer categoryId) {
        if (categoryId == null || categoryId <= 0) {
            return null;
        }
        Integer routeId = null;
        try {
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryId);
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list == null || list.size() <= 0) {
                return null;
            }
            routeId = ((EipTWorkflowCategory)list.get(0)).getEipTWorkflowRoute().getRouteId();
        }
        catch (Exception ex) {
            return null;
        }
        return routeId;
    }

    public static TurbineUser getTurbineUser(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = query.fetchList();
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            return (TurbineUser)destUserList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean isDisabledOrDeleted(String userId) {
        if (null == userId || "".equals(userId)) {
            return true;
        }
        int _userId = Integer.parseInt(userId);
        return WorkflowUtils.isDisabledOrDeleted(_userId);
    }

    public static boolean isDisabledOrDeleted(int userId) {
        try {
            TurbineUser user = ALEipUtils.getTurbineUser((int)userId);
            if (user == null) {
                return true;
            }
            String disabled = user.getDisabled();
            return DB_STATUS_THROUGH.equals(disabled) || "N".equals(disabled);
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"Exception", (Throwable)e);
            return true;
        }
    }
}

