/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowFile;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowSelectData
extends ALAbstractSelectData<EipTWorkflowRequest, EipTWorkflowRequest>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowSelectData.class.getName());
    public static final String SUBMENU_REQUESTED = "requested";
    public static final String SUBMENU_CREATED = "created";
    public static final String TAB_UNCONFIRMED = "unconfirmed";
    public static final String TAB_CONFIRMED = "confirmed";
    public static final String TAB_COMPLETED = "completed";
    public static final String TAB_UNFINISHED = "unfinished";
    public static final String TAB_FINISHED = "finished";
    private String currentSubMenu;
    private String currentTab;
    private List<WorkflowCategoryResultData> categoryList;
    private List<WorkflowRouteResultData> routeList;
    private int requestSum;
    private ALEipUser login_user;
    private ALNumberField previous_id;
    private boolean hasAuthorityOther;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sorttype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ("create_date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && (sorttype == null || "".equals(sorttype))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        String subMenuParam = rundata.getParameters().getString("submenu");
        this.currentSubMenu = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"submenu");
        if (subMenuParam == null && this.currentSubMenu == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"submenu", (String)SUBMENU_REQUESTED);
            this.currentSubMenu = SUBMENU_REQUESTED;
        } else if (subMenuParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"submenu", (String)subMenuParam);
            this.currentSubMenu = subMenuParam;
        }
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            tabParam = SUBMENU_REQUESTED.equals(this.currentSubMenu) ? TAB_UNCONFIRMED : TAB_UNFINISHED;
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        if (SUBMENU_REQUESTED.equals(this.currentSubMenu)) {
            if (TAB_UNFINISHED.equals(this.currentTab) || TAB_FINISHED.equals(this.currentTab)) {
                this.currentTab = TAB_UNCONFIRMED;
            }
        } else if (TAB_UNCONFIRMED.equals(this.currentTab) || TAB_CONFIRMED.equals(this.currentTab) || TAB_COMPLETED.equals(this.currentTab)) {
            this.currentTab = TAB_UNFINISHED;
        }
        try {
            this.previous_id = new ALNumberField();
            String previd = rundata.getParameters().getString("prvid");
            this.previous_id.setValue(previd);
        }
        catch (Exception e) {
            this.previous_id = null;
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthorityOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "workflow_request_other", 1);
        super.init(action, rundata, context);
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = WorkflowUtils.loadCategoryList(rundata, context);
    }

    public void loadRouteList(RunData rundata, Context context) {
        this.routeList = WorkflowUtils.loadRouteList(rundata, context);
    }

    public ResultList<EipTWorkflowRequest> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTWorkflowRequest> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.requestSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTWorkflowRequest> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTWorkflowRequest.class);
        Integer login_user_id = (int)this.login_user.getUserId().getValue();
        if (SUBMENU_REQUESTED.equals(this.currentSubMenu)) {
            Expression exp1 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.userId", (Object)login_user_id);
            query.setQualifier(exp1);
            if (TAB_UNCONFIRMED.equals(this.currentTab)) {
                Expression exp21 = ExpressionFactory.matchExp((String)"progress", (Object)"W");
                Expression exp22 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)"C");
                Expression exp31 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)"R");
                Expression exp32 = ExpressionFactory.matchExp((String)"progress", (Object)"D");
                query.andQualifier(exp21.andExp(exp22).orExp(exp31.andExp(exp32)));
            } else if (TAB_CONFIRMED.equals(this.currentTab)) {
                Expression exp2 = ExpressionFactory.matchExp((String)"progress", (Object)"W");
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)"A");
                query.andQualifier(exp3);
            } else {
                Expression exp2 = ExpressionFactory.matchExp((String)"progress", (Object)"A");
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTWorkflowRequestMap.status", (Object)"A");
                query.andQualifier(exp3);
            }
        } else {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)login_user_id);
            query.setQualifier(exp1);
            if (TAB_UNFINISHED.equals(this.currentTab)) {
                ArrayList<String> progressList = new ArrayList<String>();
                progressList.add("W");
                progressList.add("D");
                Expression exp2 = ExpressionFactory.inExp((String)"progress", progressList);
                query.andQualifier(exp2);
                ArrayList<String> stausList = new ArrayList<String>();
                stausList.add("C");
                stausList.add("W");
                stausList.add("D");
                Expression exp3 = ExpressionFactory.inExp((String)"eipTWorkflowRequestMap.status", stausList);
                query.andQualifier(exp3);
            } else {
                Expression exp2 = ExpressionFactory.matchExp((String)"progress", (Object)"A");
                query.andQualifier(exp2);
            }
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(EipTWorkflowRequest record) {
        try {
            WorkflowResultData rd = new WorkflowResultData();
            rd.initField();
            rd.setRequestId(record.getRequestId().intValue());
            rd.setCategoryId(record.getEipTWorkflowCategory().getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTWorkflowCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setRequestName(ALCommonUtils.compressString((String)record.getRequestName(), (int)this.getStrLength()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(WorkflowUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(WorkflowUtils.getPriorityString(record.getPriority().intValue()));
            rd.setProgress(record.getProgress());
            rd.setPrice(record.getPrice());
            String lastUpdateUser = null;
            EipTWorkflowRequestMap map = null;
            int order = 0;
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(record);
            int size = maps.size();
            if ("A".equals(record.getProgress())) {
                map = maps.get(size - 1);
                ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                lastUpdateUser = user.getAliasName().getValue();
                order = map.getOrderIndex();
            } else {
                for (int i = 0; i < size; ++i) {
                    map = maps.get(i);
                    if (!"C".equals(map.getStatus())) continue;
                    ALEipUser user = ALEipUtils.getALEipUser((int)map.getUserId());
                    lastUpdateUser = user.getAliasName().getValue();
                    order = map.getOrderIndex() - 1;
                    break;
                }
            }
            rd.setStateString(order + "/" + (size - 1));
            rd.setLastUpdateUser(lastUpdateUser);
            rd.setCreateDate(WorkflowUtils.translateDate(record.getCreateDate(), "yyyy\u5e74M\u6708d\u65e5H\u6642m\u5206"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public EipTWorkflowRequest selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequest(rundata, context, false);
        String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        WhatsNewUtils.shiftWhatsNewReadFlag((int)3, (int)Integer.parseInt(entryid), (int)((int)this.login_user.getUserId().getValue()));
        return request;
    }

    protected Object getResultDataDetail(EipTWorkflowRequest obj) {
        return WorkflowUtils.getResultDataDetail(obj, this.login_user);
    }

    private SelectQuery<EipTWorkflowFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTWorkflowFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"REQUEST_ID", (Object)requestid);
        query.setQualifier(exp);
        return query;
    }

    public List<WorkflowCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public List<WorkflowRouteResultData> getRouteList() {
        return this.routeList;
    }

    public String getCurrentSubMenu() {
        return this.currentSubMenu;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getRequestSum() {
        return this.requestSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("request_name", "requestName");
        map.putValue("priority", "priority");
        map.putValue("price", "price");
        map.putValue("create_date", "createDate");
        map.putValue("category", "eipTWorkflowCategory.CATEGORY_ID");
        return map;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALNumberField getPreviousID() {
        return this.previous_id;
    }

    public String getAclPortletFeature() {
        return "workflow_request_self";
    }

    public boolean hasAuthorityOther() {
        return this.hasAuthorityOther;
    }
}

