/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.WorkflowRouteDetailResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.Date;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowRouteSelectData
extends ALAbstractSelectData<EipTWorkflowRoute, EipTWorkflowRoute>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowRouteSelectData.class.getName());
    private int routeSum;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sorttype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ("create_date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && (sorttype == null || "".equals(sorttype))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipTWorkflowRoute> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTWorkflowRoute> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.routeSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTWorkflowRoute> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTWorkflowRoute.class);
        return query;
    }

    protected EipTWorkflowRoute selectDetail(RunData rundata, Context context) {
        return WorkflowUtils.getEipTWorkflowRoute(rundata, context);
    }

    protected Object getResultData(EipTWorkflowRoute record) {
        WorkflowRouteResultData rd = new WorkflowRouteResultData();
        rd.initField();
        rd.setRouteId(record.getRouteId().longValue());
        rd.setRouteName(ALCommonUtils.compressString((String)record.getRouteName(), (int)this.getStrLength()));
        rd.setRoute(ALCommonUtils.compressString((String)record.getRoute(), (int)this.getStrLength()));
        return rd;
    }

    protected Object getResultDataDetail(EipTWorkflowRoute record) {
        WorkflowRouteDetailResultData rd = new WorkflowRouteDetailResultData();
        rd.initField();
        rd.setRouteId(record.getRouteId().longValue());
        rd.setRouteName(record.getRouteName());
        rd.setNote(record.getNote());
        rd.setRoute(record.getRoute());
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("route_name", "routeName");
        map.putValue("route", "route");
        return map;
    }

    public int getRouteSum() {
        return this.routeSum;
    }
}

