/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowRouteFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowRouteFormData.class.getName());
    private ALStringField route_name;
    private ALStringField note;
    private ALStringField route;
    private Integer route_id;
    private List<ALEipUser> memberList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String routeid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (routeid != null && Integer.valueOf(routeid) != null) {
            this.route_id = Integer.valueOf(routeid);
        }
    }

    public void initField() {
        this.route_name = new ALStringField();
        this.route_name.setFieldName("\u7533\u8acb\u7d4c\u8def\u540d");
        this.route_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
        this.route = new ALStringField();
        this.route.setFieldName("\u7533\u8acb\u7d4c\u8def");
        this.route.setTrim(true);
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] userNames = rundata.getParameters().getStrings("positions");
                if (userNames != null && userNames.length > 0) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])userNames);
                    Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
                    query.setQualifier(exp1);
                    query.andQualifier(exp2);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                    List list = query.fetchList();
                    TurbineUser record = null;
                    int length = userNames.length;
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        record = this.getEipUserRecord(list, (String)userNames[i]);
                        builder.append(record.getUserId());
                        if (i == userNames.length - 1) continue;
                        builder.append(",");
                    }
                    String stCsv = builder.toString();
                    this.route.setValue(stCsv);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[WorkflowRouteFormData]", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.route_name.setNotNull(true);
        this.route_name.limitMaxLength(50);
        this.route.limitMaxLength(1000);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"routeName", (Object)this.route_name.getValue());
            query.setQualifier(exp1);
            if ("update".equals(this.getMode())) {
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"ROUTE_ID", (Object)this.route_id);
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add("\u7533\u8acb\u7d4c\u8def\u540d\u300e <span class='em'>" + this.route_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            if (this.route.getValue() == null) {
                msgList.add("\u300e <span class='em'>\u7533\u8acb\u5148</span> \u300f\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.route_name.validate(msgList);
        this.note.validate(msgList);
        this.route.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute routeobj = WorkflowUtils.getEipTWorkflowRoute(rundata, context);
            if (this.route == null) {
                return false;
            }
            this.route_name.setValue(routeobj.getRouteName());
            this.route.setValue(routeobj.getRoute());
            this.note.setValue(routeobj.getNote());
            String users = routeobj.getRoute();
            StringTokenizer st = new StringTokenizer(users, ",");
            int size = st.countTokens();
            Object[] userarray = new String[size];
            for (int i = 0; i < size; ++i) {
                userarray[i] = st.nextToken();
            }
            if (size > 0) {
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", (Object[])userarray);
                query.setQualifier(exp);
                List memberListTmp = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
                for (int i = 0; i < userarray.length; ++i) {
                    for (int j = 0; j < memberListTmp.size(); ++j) {
                        ALEipUser usertmp = (ALEipUser)memberListTmp.get(j);
                        if (((String)userarray[i]).compareTo(usertmp.getUserId().toString()) != 0) continue;
                        this.memberList.add(usertmp);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute routeobj = (EipTWorkflowRoute)Database.create(EipTWorkflowRoute.class);
            routeobj.setRouteName(this.route_name.getValue());
            routeobj.setNote(this.note.getValue());
            routeobj.setCreateDate(Calendar.getInstance().getTime());
            routeobj.setUpdateDate(Calendar.getInstance().getTime());
            routeobj.setRoute(this.route.getValue());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(routeobj.getRouteId().intValue(), 122, routeobj.getRouteName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute routeobj = WorkflowUtils.getEipTWorkflowRoute(rundata, context);
            if (this.route == null) {
                return false;
            }
            routeobj.setRouteName(this.route_name.getValue());
            routeobj.setRoute(this.route.getValue());
            routeobj.setNote(this.note.getValue());
            routeobj.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(routeobj.getRouteId().intValue(), 122, routeobj.getRouteName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute routeobj = WorkflowUtils.getEipTWorkflowRoute(rundata, context);
            if (routeobj == null) {
                return false;
            }
            if (routeobj.getRouteId() == 1) {
                msgList.add("\u5206\u985e\u540d\u300e <span class='em'>\u672a\u5206\u985e</span> \u300f\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            Database.delete((Persistent)routeobj);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(routeobj.getRouteId().intValue(), 122, routeobj.getRouteName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getRouteName() {
        return this.route_name;
    }

    public ALStringField getRoute() {
        return this.route;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    private TurbineUser getEipUserRecord(List<TurbineUser> userList, String userName) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = userList.get(i);
            if (!record.getLoginName().equals(userName)) continue;
            return record;
        }
        return null;
    }
}

