/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowFile;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowFormData.class.getName());
    private ALStringField request_name;
    private ALNumberField category_id;
    private ALNumberField route_id;
    private ALStringField route;
    private ALNumberField priority;
    private ALStringField note;
    private ALNumberField price;
    private List<WorkflowCategoryResultData> categoryList;
    private List<WorkflowRouteResultData> routeList;
    private ALStringField positions;
    private List<ALEipUser> memberList;
    private List<FileuploadLiteBean> fileuploadList;
    private String folderName = null;
    private String org_id;
    private int uid;
    private boolean is_saved_route;
    private ALEipUser login_user;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.request_name = new ALStringField();
        this.request_name.setFieldName("\u8868\u984c");
        this.request_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.route_id = new ALNumberField();
        this.route_id.setFieldName("\u7533\u8acb\u7d4c\u8def");
        this.route = new ALStringField();
        this.request_name.setTrim(true);
        this.priority = new ALNumberField(3L);
        this.priority.setFieldName("\u91cd\u8981\u5ea6");
        this.note = new ALStringField();
        this.note.setFieldName("\u7533\u8acb\u5185\u5bb9");
        this.note.setTrim(false);
        this.price = new ALNumberField();
        this.price.setFieldName("\u91d1\u984d");
        this.positions = new ALStringField();
        this.positions.setFieldName("\u30e6\u30fc\u30b6\u540d\u30ea\u30b9\u30c8");
        this.positions.setTrim(true);
        this.memberList = new ArrayList<ALEipUser>();
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = WorkflowUtils.loadCategoryList(rundata, context);
    }

    public void loadRouteList(RunData rundata, Context context) {
        this.routeList = WorkflowUtils.loadRouteList(rundata, context);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res;
        block10: {
            block9: {
                res = super.setFormData(rundata, context, msgList);
                if (!res) break block10;
                try {
                    block12: {
                        Expression exp1;
                        Object[] userNames;
                        block11: {
                            String mode = rundata.getParameters().getString("mode");
                            if (!"insert".equals(mode) && !"update".equals(mode)) break block9;
                            this.is_saved_route = rundata.getParameters().getBoolean("is_saved_route");
                            userNames = rundata.getParameters().getStrings("positions");
                            if (!this.is_saved_route) break block11;
                            SelectQuery query1 = Database.query(EipTWorkflowRoute.class);
                            exp1 = ExpressionFactory.matchDbExp((String)"ROUTE_ID", (Object)this.route_id.getValue());
                            query1.setQualifier(exp1);
                            List list1 = query1.fetchList();
                            EipTWorkflowRoute record = (EipTWorkflowRoute)list1.get(0);
                            String route = record.getRoute();
                            if ("".equals(route)) break block12;
                            StringTokenizer st = new StringTokenizer(route, ",");
                            int lengthru = st.countTokens();
                            Object[] routeUserNames = new String[lengthru];
                            for (int i = 0; i < lengthru; ++i) {
                                routeUserNames[i] = WorkflowUtils.getUserName(st.nextToken());
                            }
                            SelectQuery query = Database.query(TurbineUser.class);
                            Expression exp2 = ExpressionFactory.inExp((String)"loginName", (Object[])routeUserNames);
                            query.setQualifier(exp2);
                            List list = query.fetchList();
                            TurbineUser record1 = null;
                            int length = routeUserNames.length;
                            int enableUserNum = 0;
                            for (int i = 0; i < length; ++i) {
                                record1 = this.getEipUserRecord(list, (String)routeUserNames[i]);
                                if ("F".equals(record1.getDisabled())) {
                                    ++enableUserNum;
                                }
                                ALEipUser user = new ALEipUser();
                                user.initField();
                                user.setUserId(record1.getUserId().intValue());
                                user.setName(record1.getLoginName());
                                user.setAliasName(record1.getFirstName(), record1.getLastName());
                                this.memberList.add(user);
                            }
                            if (enableUserNum != 0) break block12;
                            this.memberList.clear();
                            this.memberList.add(null);
                            break block12;
                        }
                        if (userNames != null && userNames.length > 0) {
                            SelectQuery query = Database.query(TurbineUser.class);
                            exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])userNames);
                            Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
                            query.setQualifier(exp1);
                            query.andQualifier(exp2);
                            List list = query.fetchList();
                            TurbineUser record = null;
                            int length = userNames.length;
                            for (int i = 0; i < length; ++i) {
                                record = this.getEipUserRecord(list, (String)userNames[i]);
                                ALEipUser user = new ALEipUser();
                                user.initField();
                                user.setUserId(record.getUserId().intValue());
                                user.setName(record.getLoginName());
                                user.setAliasName(record.getFirstName(), record.getLastName());
                                this.memberList.add(user);
                            }
                        }
                    }
                    this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
                }
                catch (Exception ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                }
            }
            this.category_id.getValue();
            String[] event = rundata.getParameters().getStrings("event");
            if (event != null) {
                for (WorkflowCategoryResultData tmp : this.categoryList) {
                    if (tmp.getCategoryId().getValue() != this.category_id.getValue()) continue;
                    this.note.setValue(tmp.getOrderTemplate().toString());
                }
            }
        }
        return res;
    }

    public String categoryTemplate(int num) {
        for (WorkflowCategoryResultData o : this.categoryList) {
            WorkflowCategoryResultData tmp = o;
            if (tmp.getCategoryId().getValue() != (long)num) continue;
            return tmp.getOrderTemplate().getValue();
        }
        return "";
    }

    private TurbineUser getEipUserRecord(List<TurbineUser> userList, String userName) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = userList.get(i);
            if (!record.getLoginName().equals(userName)) continue;
            return record;
        }
        return null;
    }

    protected void setValidator() {
        this.request_name.limitMaxLength(50);
        this.price.limitMaxValue(1000000000L);
        this.note.setNotNull(true);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        this.request_name.validate(msgList);
        this.note.validate(msgList);
        this.price.validate(msgList);
        if (this.memberList == null || this.memberList.size() <= 0) {
            msgList.add("\u300e <span class='em'>\u7533\u8acb\u5148</span> \u300f\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        } else if (!(this.memberList.get(0) instanceof ALEipUser)) {
            msgList.add("\u7533\u8acb\u5148\u306e\u30e6\u30fc\u30b6\u30fc\u304c\u5168\u3066\u7121\u52b9\u3001\u3082\u3057\u304f\u306f\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u6709\u52b9\u306a\u30e6\u30fc\u30b6\u30fc\u304c\u4e00\u4eba\u4ee5\u4e0a\u3044\u308b\u7d4c\u8def\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequestForOwner(rundata, context);
            if (request == null) {
                return false;
            }
            this.request_name.setValue(request.getRequestName());
            this.category_id.setValue(request.getEipTWorkflowCategory().getCategoryId().longValue());
            if (request.getEipTWorkflowRoute() != null) {
                this.is_saved_route = true;
                this.route_id.setValue(request.getEipTWorkflowRoute().getRouteId().longValue());
                this.route.setValue(request.getEipTWorkflowRoute().getRoute());
            }
            this.priority.setValue(request.getPriority().longValue());
            this.note.setValue(request.getNote());
            this.price.setValue(request.getPrice().longValue());
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(request);
            EipTWorkflowRequestMap map = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                int user_id = map.getUserId();
                if ("R".equals(map.getStatus())) continue;
                this.memberList.add(ALEipUtils.getALEipUser((int)user_id));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequestAll(rundata, context);
            int userId = ALEipUtils.getUserId((RunData)rundata);
            if (!request.getUserId().equals(userId)) {
                EipTWorkflowRequestMap requestMap;
                List<EipTWorkflowRequestMap> requestMapList = WorkflowUtils.getEipTWorkflowRequestMap(request);
                int listLength = requestMapList.size();
                for (int i = 0; i < listLength && (requestMap = requestMapList.get(i)).getUserId() != userId; ++i) {
                    TurbineUser requestMapUser = WorkflowUtils.getTurbineUser(requestMap.getUserId().toString());
                    if (!"F".equals(requestMapUser.getDisabled())) continue;
                    return false;
                }
            }
            String catname = request.getEipTWorkflowCategory().getCategoryName();
            String reqname = request.getRequestName();
            ArrayList<String> fpaths = new ArrayList<String>();
            SelectQuery query = Database.query(EipTWorkflowFile.class);
            query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTWorkflowRequest", (Object)request.getRequestId()));
            List files = query.fetchList();
            if (files != null && files.size() > 0) {
                int fsize = files.size();
                for (int j = 0; j < fsize; ++j) {
                    fpaths.add(((EipTWorkflowFile)files.get(j)).getFilePath());
                }
            }
            if (fpaths.size() > 0) {
                File file = null;
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    file = new File(WorkflowUtils.getSaveDirPath(this.org_id, this.uid) + (String)fpaths.get(i));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            Database.delete((Persistent)request);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, catname + " " + reqname);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int i;
            Date nowDate = Calendar.getInstance().getTime();
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(this.category_id.getValue());
            EipTWorkflowRequest request = (EipTWorkflowRequest)Database.create(EipTWorkflowRequest.class);
            request.setRequestName(this.request_name.getValue());
            request.setParentId(Integer.valueOf(0));
            request.setEipTWorkflowCategory(category);
            if (this.is_saved_route) {
                EipTWorkflowRoute route = WorkflowUtils.getEipTWorkflowRoute(this.route_id.getValue());
                request.setEipTWorkflowRoute(route);
            }
            request.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            request.setPriority(Short.valueOf((short)this.priority.getValue()));
            request.setNote(this.note.getValue());
            request.setPrice(Long.valueOf(this.price.getValue()));
            request.setProgress("W");
            request.setCreateDate(Calendar.getInstance().getTime());
            request.setUpdateDate(Calendar.getInstance().getTime());
            this.insertEipTWorkflowRequestMap(request, this.login_user, "R", 0, nowDate);
            int size = this.memberList.size();
            for (i = 0; i < size; ++i) {
                ALEipUser toUser = this.memberList.get(i);
                if (!WorkflowUtils.isDisabledOrDeleted(toUser.getUserId().getValueAsString())) {
                    this.insertEipTWorkflowRequestMap(request, toUser, "C", i + 1, nowDate);
                    break;
                }
                this.insertEipTWorkflowRequestMap(request, toUser, "T", i + 1, nowDate);
            }
            for (int j = i + 1; j < size; ++j) {
                this.insertEipTWorkflowRequestMap(request, this.memberList.get(j), "W", j + 1, nowDate);
            }
            if (!WorkflowUtils.insertFileDataDelegate(rundata, context, request, null, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + this.request_name.getValue());
            ALEipUser nextUser = this.memberList.get(i);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority((int)nextUser.getUserId().getValue(), "workflow_request_self", 2)) {
                WhatsNewUtils.insertWhatsNew((int)3, (int)request.getRequestId(), (int)((int)nextUser.getUserId().getValue()));
            }
            ArrayList<ALEipUser> destUsers = new ArrayList<ALEipUser>();
            destUsers.add(nextUser);
            WorkflowUtils.sendMail(rundata, request, destUsers, new ArrayList<String>());
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)this.uid, (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int i;
            EipTWorkflowRequest oldrequest = WorkflowUtils.getEipTWorkflowRequestForOwner(rundata, context);
            if (oldrequest == null) {
                return false;
            }
            Date nowDate = Calendar.getInstance().getTime();
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(this.category_id.getValue());
            EipTWorkflowRequest request = (EipTWorkflowRequest)Database.create(EipTWorkflowRequest.class);
            request.setRequestName(this.request_name.getValue());
            if (oldrequest.getParentId() == 0) {
                request.setParentId(oldrequest.getRequestId());
            } else {
                request.setParentId(oldrequest.getParentId());
            }
            request.setEipTWorkflowCategory(category);
            if (this.is_saved_route) {
                EipTWorkflowRoute route = WorkflowUtils.getEipTWorkflowRoute(this.route_id.getValue());
                request.setEipTWorkflowRoute(route);
            }
            request.setUserId(Integer.valueOf((int)this.login_user.getUserId().getValue()));
            request.setPriority(Short.valueOf((short)this.priority.getValue()));
            request.setNote(this.note.getValue());
            request.setPrice(Long.valueOf(this.price.getValue()));
            request.setProgress("W");
            request.setCreateDate(Calendar.getInstance().getTime());
            request.setUpdateDate(Calendar.getInstance().getTime());
            this.insertEipTWorkflowRequestMap(request, this.login_user, "R", 0, nowDate);
            int size = this.memberList.size();
            for (i = 0; i < size; ++i) {
                ALEipUser toUser = this.memberList.get(i);
                if (!WorkflowUtils.isDisabledOrDeleted(toUser.getUserId().getValueAsString())) {
                    this.insertEipTWorkflowRequestMap(request, toUser, "C", i + 1, nowDate);
                    break;
                }
                this.insertEipTWorkflowRequestMap(request, toUser, "T", i + 1, nowDate);
            }
            for (int j = i + 1; j < size; ++j) {
                this.insertEipTWorkflowRequestMap(request, this.memberList.get(j), "W", j + 1, nowDate);
            }
            if (!WorkflowUtils.insertFileDataDelegate(rundata, context, request, oldrequest, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            oldrequest.setProgress("R");
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + this.request_name.getValue());
            ALEipUser nextUser = this.memberList.get(i);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority((int)nextUser.getUserId().getValue(), "workflow_request_self", 2)) {
                WhatsNewUtils.insertWhatsNew((int)3, (int)request.getRequestId(), (int)((int)nextUser.getUserId().getValue()));
            }
            ArrayList<ALEipUser> destUsers = new ArrayList<ALEipUser>();
            destUsers.add(nextUser);
            WorkflowUtils.sendMail(rundata, request, destUsers, new ArrayList<String>());
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)this.uid, (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void insertEipTWorkflowRequestMap(EipTWorkflowRequest request, ALEipUser user, String status, int order, Date now) {
        EipTWorkflowRequestMap map = (EipTWorkflowRequestMap)Database.create(EipTWorkflowRequestMap.class);
        int userid = (int)user.getUserId().getValue();
        map.setEipTWorkflowRequest(request);
        map.setUserId(Integer.valueOf(userid));
        map.setStatus(status);
        map.setOrderIndex(Integer.valueOf(order));
        map.setCreateDate(now);
        map.setUpdateDate(now);
    }

    public String getRouteMap(int num) {
        for (WorkflowRouteResultData o : this.routeList) {
            WorkflowRouteResultData tmp = o;
            if (tmp.getRouteId().getValue() != (long)num) continue;
            String route = tmp.getRoute().getValue();
            String[] routeArray = route.split(",");
            int routeArrayLength = routeArray.length;
            List list = new ArrayList();
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp11 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)routeArray[0]);
            for (int i = 1; i < routeArrayLength; ++i) {
                Expression exptmp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)routeArray[i]);
                exp = exp.orExp(exptmp);
            }
            exp = exp.andExp(exp11);
            query.setQualifier(exp);
            list = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            StringBuffer result = new StringBuffer();
            ALEipUser user = null;
            int listsize = list.size();
            for (int i = 0; i < routeArrayLength; ++i) {
                for (int j = 0; j < listsize; ++j) {
                    user = (ALEipUser)list.get(j);
                    String userid = user.getUserId().toString();
                    if (!userid.equals(routeArray[i])) continue;
                    result.append(user.getName()).append(",").append(user.getAliasName().toString()).append(",");
                }
            }
            return result.toString();
        }
        return null;
    }

    public String getRouteHTemplate(int num) {
        for (WorkflowRouteResultData o : this.routeList) {
            WorkflowRouteResultData tmp = o;
            if (tmp.getRouteId().getValue() != (long)num) continue;
            return tmp.getRouteH();
        }
        return "";
    }

    public String getRouteH() {
        StringBuffer routeun = new StringBuffer();
        if (this.route.getValue() != null && !"".equals(this.route.getValue())) {
            StringTokenizer st = new StringTokenizer(this.route.getValue(), ",");
            while (st.hasMoreTokens()) {
                String username = WorkflowUtils.getName(st.nextToken());
                routeun.append(username);
                routeun.append(" -> ");
            }
            routeun.append("\u5b8c\u4e86");
            return routeun.toString();
        }
        return "";
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALNumberField getRouteId() {
        return this.route_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public void setNote(String str) {
        this.note.setValue(str);
    }

    public ALNumberField getPrice() {
        return this.price;
    }

    public void setPrice(String str) {
        this.price.setValue(str);
    }

    public ALNumberField getPriority() {
        return this.priority;
    }

    public void setPriority(String str) {
        this.priority.setValue(str);
    }

    public ALStringField getRequestName() {
        return this.request_name;
    }

    public void setRequestName(String str) {
        this.request_name.setValue(str);
    }

    public List<WorkflowCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public List<WorkflowRouteResultData> getRouteList() {
        return this.routeList;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(ArrayList<ALEipUser> list) {
        this.memberList = list;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public boolean getIsSavedRoute() {
        return this.is_saved_route;
    }

    public String getAclPortletFeature() {
        return "workflow_request_self";
    }
}

