/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.beans;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleBean
implements ALData,
Cloneable {
    private ALNumberField schedule_id;
    private ALNumberField parent_id;
    private ALStringField owner_name;
    private ALStringField owner_id;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private ALStringField name;
    private ALStringField place;
    private String ptn;
    private String format = "HH:mm";
    private boolean is_owner;
    private boolean is_tmpreserve;
    private boolean is_duplicate;
    private boolean is_public;
    private boolean is_hidden;
    private boolean is_loginuser;
    private boolean is_member;
    private boolean is_confirm;
    private boolean is_repeat;
    private boolean is_dummy;
    private boolean is_editable;
    private ALStringField type;
    private int rowspan;
    private int colspanReal;
    private int index;
    private int indexReal;
    private List<String> tmpList;

    public void initField() {
        this.name = new ALStringField();
        this.type = new ALStringField();
        this.place = new ALStringField();
        this.schedule_id = new ALNumberField();
        this.parent_id = new ALNumberField();
        this.owner_name = new ALStringField();
        this.owner_id = new ALStringField();
        this.start_date = new ALDateTimeField(this.format);
        this.end_date = new ALDateTimeField(this.format);
        this.is_owner = true;
        this.is_tmpreserve = false;
        this.is_duplicate = false;
        this.is_public = true;
        this.is_hidden = false;
        this.is_loginuser = true;
        this.is_member = true;
        this.is_confirm = false;
        this.is_repeat = false;
        this.is_dummy = false;
        this.tmpList = null;
    }

    public void setResultData(AjaxScheduleResultData rd) {
        this.name = rd.getName();
        this.schedule_id = rd.getScheduleId();
        this.parent_id = rd.getParentId();
        this.place = rd.getPlace();
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)rd.getUserId());
            if (user == null) {
                this.owner_name.setValue("");
                this.owner_id.setValue("");
            } else {
                this.owner_name.setValue(user.getName().toString());
                this.owner_id.setValue(user.getUserId().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start_date = rd.getStartDate();
        this.end_date = rd.getEndDate();
        this.is_owner = rd.isOwner();
        this.is_tmpreserve = rd.isTmpreserve();
        this.is_public = rd.isPublic();
        this.is_duplicate = rd.isDuplicate();
        this.is_hidden = rd.isHidden();
        this.is_loginuser = rd.isLoginuser();
        this.is_member = rd.isMember();
        this.is_confirm = rd.isConfirm();
        this.is_repeat = rd.isRepeat();
        this.is_dummy = rd.isDummy();
        this.ptn = rd.getPattern();
        this.is_editable = rd.isEditable();
        this.rowspan = rd.getRowspan();
        this.type.setValue(rd.getType());
        this.tmpList = rd.getMemberList();
    }

    public List<String> getMemberList() {
        return this.tmpList;
    }

    public void setMemberList(List<String> list) {
        this.tmpList = list;
    }

    public String getStartDateHour() {
        return this.start_date.toStringHour();
    }

    public String getStartDateMinute() {
        return this.start_date.toStringMinute();
    }

    public String getEndDateHour() {
        return this.end_date.toStringHour();
    }

    public String getEndDateMinute() {
        return this.end_date.toStringMinute();
    }

    public String getEndDate() {
        return this.end_date.toString();
    }

    public String getStartDate() {
        return this.start_date.toString();
    }

    public void setEndDate(Date date) {
        this.end_date.setValue(date);
    }

    public void setStartDate(Date date) {
        this.start_date.setValue(date);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getPlace() {
        return this.place.toString();
    }

    public boolean isShowDetail() {
        return this.is_loginuser || this.is_public || this.is_owner || this.is_member;
    }

    public void setName(String string) {
        this.name.setValue(string);
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getScheduleId() {
        return this.schedule_id.toString();
    }

    public void setScheduleId(int number) {
        this.schedule_id.setValue((long)number);
    }

    public String getParentId() {
        return this.parent_id.toString();
    }

    public void setParentId(int number) {
        this.parent_id.setValue((long)number);
    }

    public void setOwner(boolean bool) {
        this.is_owner = bool;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public boolean isTmpreserve() {
        return this.is_tmpreserve;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    public void setTmpreserve(boolean bool) {
        this.is_tmpreserve = bool;
    }

    public boolean isConfirm() {
        return this.is_confirm;
    }

    public void setConfirm(boolean bool) {
        this.is_confirm = bool;
    }

    public boolean isDuplicate() {
        return this.is_duplicate;
    }

    public void setDuplicate(boolean bool) {
        this.is_duplicate = bool;
    }

    public void setPublic(boolean bool) {
        this.is_public = bool;
    }

    public boolean isHidden() {
        return this.is_hidden;
    }

    public void setHidden(boolean bool) {
        this.is_hidden = bool;
    }

    public boolean isPrivate() {
        return !this.is_public && !this.is_hidden;
    }

    public boolean isLoginuser() {
        return this.is_loginuser;
    }

    public void setLoginuser(boolean b) {
        this.is_loginuser = b;
    }

    public boolean isMember() {
        return this.is_member;
    }

    public void setMember(boolean b) {
        this.is_member = b;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public void setRepeat(boolean bool) {
        this.is_repeat = bool;
    }

    public boolean isDummy() {
        return this.is_dummy;
    }

    public void setDummy(boolean bool) {
        this.is_dummy = bool;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void setRowspan(int number) {
        this.rowspan = number;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public String getPattern() {
        return this.ptn;
    }

    public void setPattern(String string) {
        this.ptn = string;
    }

    public boolean isEditable() {
        return this.is_editable;
    }

    public void setEditFlag(boolean bool) {
        this.is_editable = bool;
    }

    public String getDate() {
        if (this.start_date.getValue().equals(this.end_date.getValue())) {
            return this.start_date.toString();
        }
        if (this.start_date.getYear().equals(this.end_date.getYear()) && this.start_date.getMonth().equals(this.end_date.getMonth()) && this.start_date.getDay().equals(this.end_date.getDay()) || this.is_repeat) {
            return new StringBuffer().append(this.start_date.toString()).append('-').append(this.end_date.toString()).toString();
        }
        return new StringBuffer().append(this.start_date.toString()).append('-').append("24:00").toString();
    }

    public String getDate2() {
        if (this.start_date.getValue().equals(this.end_date.getValue())) {
            return this.start_date.toString();
        }
        if (this.start_date.getYear().equals(this.end_date.getYear()) && this.start_date.getMonth().equals(this.end_date.getMonth()) && this.start_date.getDay().equals(this.end_date.getDay()) || this.is_repeat) {
            return new StringBuffer().append(this.start_date.toString()).append('\uff5e').append(this.end_date.toString()).toString();
        }
        return new StringBuffer().append(this.start_date.toString()).append('\uff5e').append("24:00").toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getColspanReal() {
        return this.colspanReal;
    }

    public void setColspanReal(int colspanReal) {
        this.colspanReal = colspanReal;
    }

    public void setIndexReal(int index) {
        this.indexReal = index;
    }

    public int getIndexReal() {
        return this.indexReal;
    }

    public void setOwnerId(String str) {
        this.owner_id.setValue(str);
    }

    public String getOwnerId() {
        return this.owner_id.toString();
    }

    public void setOwnerName(String str) {
        this.owner_name.setValue(str);
    }

    public String getOwnerName() {
        return this.owner_name.toString();
    }

    public void setType(String str) {
        this.type.setValue(str);
    }

    public String getType() {
        return this.type.toString();
    }
}

