/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermWeekContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.ScheduleToDoWeekContainer;
import com.aimluck.eip.schedule.ScheduleWeekContainer;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleWeeklySelectData
extends ALAbstractSelectData<EipTScheduleMap, EipTScheduleMap> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleWeeklySelectData.class.getName());
    private ALDateTimeField prevDate;
    private ALDateTimeField nextDate;
    private ALDateTimeField prevWeek;
    private ALDateTimeField nextWeek;
    private ALDateTimeField today;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private ALDateTimeField viewEndCrt;
    private List<ScheduleTermWeekContainer> termWeekConList;
    private ScheduleWeekContainer weekCon;
    protected String viewtype;
    protected Calendar tmpCal;
    private List<ScheduleToDoWeekContainer> weekTodoConList;
    protected int viewTodo;
    private String portletId;
    private boolean hasAuthoritySelfInsert = false;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String tmpViewStart;
        this.viewtype = "weekly";
        this.prevDate = new ALDateTimeField("yyyy-MM-dd");
        this.nextDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevWeek = new ALDateTimeField("yyyy-MM-dd");
        this.nextWeek = new ALDateTimeField("yyyy-MM-dd");
        this.prevMonth = new ALDateTimeField("yyyy-MM-dd");
        this.nextMonth = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart.setNotNull(true);
        this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
        this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
        this.today = new ALDateTimeField("yyyy-MM-dd");
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_start")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_start", (String)rundata.getParameters().getString("view_start"));
        }
        if ((tmpViewStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_start")) == null || tmpViewStart.equals("")) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewStart.setValue(cal.getTime());
        } else {
            this.viewStart.setValue(tmpViewStart);
            if (!this.viewStart.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_start");
                throw new ALPageNotFoundException();
            }
        }
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewStart.getValue());
        cal2.add(5, 1);
        this.nextDate.setValue(cal2.getTime());
        cal2.add(5, 6);
        this.nextWeek.setValue(cal2.getTime());
        cal2.add(5, -8);
        this.prevDate.setValue(cal2.getTime());
        cal2.add(5, -6);
        this.prevWeek.setValue(cal2.getTime());
        cal2.add(5, 7);
        this.tmpCal = Calendar.getInstance();
        this.tmpCal.setTime(cal2.getTime());
        try {
            this.weekCon = new ScheduleWeekContainer();
            this.weekCon.initField();
            this.weekCon.setViewStartDate(cal2);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        this.viewEndCrt.setValue(cal2.getTime());
        cal2.add(5, -1);
        this.viewEnd.setValue(cal2.getTime());
        Calendar cal3 = Calendar.getInstance();
        cal3.setTime(this.viewStart.getValue());
        cal3.add(2, -1);
        this.prevMonth.setValue(cal3.getTime());
        cal3.add(2, 2);
        this.nextMonth.setValue(cal3.getTime());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
        this.termWeekConList = new ArrayList<ScheduleTermWeekContainer>();
        this.weekTodoConList = new ArrayList<ScheduleToDoWeekContainer>();
        if (action != null) {
            this.viewTodo = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p5a-view"));
        }
        super.init(action, rundata, context);
        int userId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthoritySelfInsert = aclhandler.hasAuthority(userId, "schedule_self", 4);
    }

    protected ResultList<EipTScheduleMap> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List list = this.getSelectQuery(rundata, context).fetchList();
            if (this.viewTodo == 1) {
                this.loadTodo(rundata, context);
            }
            ScheduleUtils.sortByTime(list);
            return new ResultList(ScheduleUtils.sortByDummySchedule(list));
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleWeeklySelectData] TorqueException");
            throw new ALDBErrorException();
        }
    }

    protected SelectQuery<EipTScheduleMap> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)this.viewEndCrt.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        return query;
    }

    protected Object getResultData(EipTScheduleMap record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        rd.initField();
        try {
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setPattern(schedule.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                int col;
                int count;
                int stime = -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col > 0) {
                    ScheduleUtils.addTermSchedule(this.termWeekConList, this.viewStart.getValue(), count, rd);
                }
                return rd;
            }
            this.weekCon.addResultData(rd);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected EipTScheduleMap selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(EipTScheduleMap obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public void loadTodo(RunData rundata, Context context) {
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            List todos = query.fetchList();
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                int col;
                int count;
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                int stime = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col <= 0) continue;
                ScheduleUtils.addToDo(this.weekTodoConList, this.viewStart.getValue(), count, rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = ALEipUtils.getUserId((RunData)rundata);
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewEndCrt.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewEndCrt.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewStart.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    public ALDateTimeField getViewEndCrt() {
        return this.viewEndCrt;
    }

    public ALDateTimeField getPrevDate() {
        return this.prevDate;
    }

    public ALDateTimeField getPrevWeek() {
        return this.prevWeek;
    }

    public ALDateTimeField getNextDate() {
        return this.nextDate;
    }

    public ALDateTimeField getNextWeek() {
        return this.nextWeek;
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public List<ScheduleTermWeekContainer> getTermContainer() {
        return this.termWeekConList;
    }

    public ScheduleWeekContainer getContainer() {
        return this.weekCon;
    }

    public List<ScheduleToDoWeekContainer> getWeekToDoContainerList() {
        return this.weekTodoConList;
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public String getAclPortletFeature() {
        return "schedule_self";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }
}

