/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.ScheduleToDoDayContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.todo.util.ToDoUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleToDoWeekContainer
implements ALData {
    private List<ScheduleToDoDayContainer> dayList;

    public void initField() {
        this.dayList = new ArrayList<ScheduleToDoDayContainer>();
    }

    public void setViewStartDate(Calendar cal) {
        for (int i = 1; i <= 7; ++i) {
            ScheduleToDoDayContainer con = new ScheduleToDoDayContainer();
            con.initField();
            con.setDate(cal.getTime());
            this.dayList.add(con);
            cal.add(5, 1);
        }
    }

    public void addToDoResultData(int index, ScheduleToDoResultData rd) {
        int span = rd.getRowspan();
        ScheduleToDoDayContainer con = this.dayList.get(index);
        con.setHasTodo(true);
        con.setToDoResultData(rd);
        for (int i = 1; i < span; ++i) {
            con = this.dayList.get(index + i);
            con.setHasTodo(true);
        }
    }

    public boolean canAddTodo(ScheduleToDoResultData rd) {
        boolean canAdd = true;
        Date startDate = rd.getStartDate().getValue();
        Date endDate = rd.getEndDate().getValue();
        int size = this.dayList.size();
        for (int i = 0; i < size; ++i) {
            ScheduleToDoDayContainer con = this.dayList.get(i);
            Date conDate = con.getDate().getValue();
            boolean isEmptyStartDate = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), startDate, false);
            boolean isEmptyEndDate = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), endDate, false);
            if (isEmptyStartDate && isEmptyEndDate) {
                if (!con.isHasTodo()) continue;
                canAdd = false;
                continue;
            }
            if (isEmptyStartDate) {
                if (!ScheduleUtils.equalsToDate(endDate, conDate, false) && !conDate.before(endDate) || !con.isHasTodo()) continue;
                canAdd = false;
                continue;
            }
            if (isEmptyEndDate) {
                if (!ScheduleUtils.equalsToDate(startDate, conDate, false) && !conDate.after(startDate) || !con.isHasTodo()) continue;
                canAdd = false;
                continue;
            }
            if (!ScheduleUtils.equalsToDate(startDate, conDate, false) && !conDate.after(startDate) || !ScheduleUtils.equalsToDate(endDate, conDate, false) && !conDate.before(endDate) || !con.isHasTodo()) continue;
            canAdd = false;
        }
        return canAdd;
    }

    public List<ScheduleToDoDayContainer> getDayList() {
        return this.dayList;
    }
}

