/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellScheduleSelectFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleSelectFormData.class.getName());
    protected ALCellDateField view_date;
    protected String view_date_str;
    protected int currentYear;

    public void initField() {
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        this.view_date = new ALCellDateField();
        this.view_date.setFieldName("\u65e5\u4ed8");
        this.view_date.setNotNull(true);
        this.view_date_str = "";
        if (rundata.getParameters().getString("view_date") == null) {
            this.view_date.setValue(now);
            this.currentYear = Calendar.getInstance().get(1);
        } else {
            String str = rundata.getParameters().getString("view_date");
            if (str.indexOf("-") == -1) {
                if (str.length() != 0) {
                    if (str.length() != 8) {
                        this.view_date_str = "0";
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append(str.substring(0, 4)).append("-").append(str.substring(4, 6)).append("-").append(str.substring(6, 8));
                        this.view_date_str = sb.toString();
                    }
                }
            } else {
                ALDateTimeField date = new ALDateTimeField("yyyy-MM-dd");
                date.setValue(str);
                this.view_date.setValue(date.getValue());
                this.currentYear = Integer.parseInt(date.getYear());
                rundata.getParameters().remove("view_date");
            }
        }
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        if (this.view_date_str.length() == 0) {
            msgList.add("\u300e \u65e5\u4ed8 \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        this.view_date.setValue(this.view_date_str);
        ArrayList msgList2 = new ArrayList();
        if (!this.view_date.validate(msgList2)) {
            msgList.addAll(msgList2);
            return false;
        }
        return msgList.size() == 0;
    }

    public boolean doCheck(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            action.setMode("new_form");
            this.setMode(action.getMode());
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean res = this.validate(msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, (ALData)this, fields, msgList);
        return res;
    }

    private EipTScheduleMap getScheduleMap(List<EipTScheduleMap> scheduleMaps, int userid) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = scheduleMaps.get(i);
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    public String getViewDateStr() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.view_date.getYear()).append("-").append(this.view_date.getMonth()).append("-").append(this.view_date.getDay());
        return sb.toString();
    }

    public ALCellDateField getViewDate() {
        return this.view_date;
    }

    public int getInt(long num) {
        return (int)num;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public String getViewDateDate() {
        try {
            return ScheduleUtils.translateDate(this.view_date.getValue().getDate(), "yyyyMMdd");
        }
        catch (Exception e) {
            return "";
        }
    }
}

