/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.CellScheduleOnedaySelectData;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellScheduleOnedaySelectByMemberData
extends CellScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleOnedaySelectByMemberData.class.getName());
    private ALEipUser targerUser;
    private List<ScheduleToDoResultData> todoList;
    private String portletId;
    private int userid;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userid = ALEipUtils.getUserId((RunData)rundata);
        String s = rundata.getParameters().getString("selectedmember");
        if (s != null) {
            this.targerUser = ALEipUtils.getALEipUser((int)Integer.parseInt(s));
        } else {
            s = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_otheruser_id");
            this.targerUser = ALEipUtils.getALEipUser((int)Integer.parseInt(s));
        }
    }

    @Override
    protected SelectQuery<EipTScheduleMap> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)this.targerUser.getUserId().getValue());
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.getViewDate().getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        ALCellDateTimeField field = new ALCellDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        Calendar date = Calendar.getInstance();
        date.setTime(this.getViewDate().getValue());
        int weekindex = date.get(6);
        String token = null;
        StringBuffer sb = new StringBuffer();
        sb.append("W");
        for (int i = 0; i < 7; ++i) {
            token = i == weekindex ? "1" : "_";
            sb.append(token);
        }
        Expression exp21 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "L"));
        Expression exp22 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "N"));
        Expression exp23 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DN");
        Expression exp31 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DL");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        sdf.setTimeZone(TimeZone.getDefault());
        String dayStr = sdf.format(date.getTime());
        Expression exp24 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "L"));
        Expression exp25 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "N"));
        query.andQualifier(exp11.andExp(exp12).andExp(exp13.orExp(exp14).orExp(exp21).orExp(exp31).orExp(exp24)).orExp(exp22.orExp(exp23).orExp(exp25)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("eipTSchedule.startDate", true));
        orders.add(new Ordering("eipTSchedule.endDate", true));
        query.getQuery().addOrderings(orders);
        return query;
    }

    @Override
    public void loadToDo(RunData rundata, Context context) {
        this.todoList = new ArrayList<ScheduleToDoResultData>();
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            List todos = query.fetchList();
            int todosize = todos.size();
            for (int i = 0; i < todosize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = this.getPortletURItoTodo(rundata, record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                this.todoList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = (int)this.targerUser.getUserId().getValue();
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    @Override
    protected Object getResultData(EipTScheduleMap record) throws ALPageNotFoundException, ALDBErrorException {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            boolean hidden;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
                return rd;
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setPattern(schedule.getRepeatPattern());
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            mapquery.andQualifier(mapexp2);
            Expression mapexp3 = ExpressionFactory.noMatchExp((String)"status", (Object)"R");
            mapquery.andQualifier(mapexp3);
            List schedulemaps = mapquery.fetchList();
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            rd.setMember(is_member);
            boolean publicable = schedule.getPublicFlag().equals("O");
            if (!publicable && !is_member) {
                rd.setName("\u975e\u516c\u958b");
            }
            if ((hidden = schedule.getPublicFlag().equals("P")) && !is_member) {
                return null;
            }
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    public ALEipUser getTargerUser() {
        return this.targerUser;
    }

    public void setTargerUser(ALEipUser targerUser) {
        this.targerUser = targerUser;
    }

    @Override
    public List<ScheduleToDoResultData> getToDoResultDataList() {
        return this.todoList;
    }

    @Override
    public void setPortletId(String id) {
        this.portletId = id;
    }
}

