/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.AbstractCellScheduleFormData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellScheduleFormMemberData
extends AbstractCellScheduleFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormMemberData.class.getName());
    private List<ALEipGroup> groups;
    private ALCellStringField selected_group;
    private int rows_num = 10;
    private int start;
    private int count;
    private int pages_num = 1;
    private int current_page = 1;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"start")) {
            this.current_page = rundata.getParameters().getInt("start");
        }
        this.selected_group.setValue(rundata.getParameters().get("selectedgroup"));
        super.init(action, rundata, context);
    }

    @Override
    public void initField() {
        this.selected_group = new ALCellStringField();
        super.initField();
    }

    @Override
    protected void loadCustomFormData(EipTSchedule record) {
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    @Override
    public List<ALEipUser> getUsers(String groupname) {
        if (groupname == null || groupname.length() == 0) {
            return new ArrayList<ALEipUser>();
        }
        if ("all".equals(groupname)) {
            groupname = "LoginUser";
        }
        List userlist = ALEipUtils.getUsers((String)groupname);
        ScheduleUtils.removeUser(userlist, this.getLoginUser());
        int size = userlist.size();
        this.setPageParam(size);
        int start = this.getStart();
        int rowsNum = this.getRowsNum();
        int count = -1;
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        for (int i = 0; i < rowsNum && (count = i + start) < size; ++i) {
            list.add((ALEipUser)userlist.get(count));
        }
        return list;
    }

    public List<ALEipUser> getUsers_not_page(String groupname) {
        if (groupname == null || groupname.length() == 0) {
            return new ArrayList<ALEipUser>();
        }
        if ("all".equals(groupname)) {
            groupname = "LoginUser";
        }
        List userlist = ALEipUtils.getUsers((String)groupname);
        ScheduleUtils.removeUser(userlist, this.getLoginUser());
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        for (int i = 0; i < userlist.size(); ++i) {
            list.add((ALEipUser)userlist.get(i));
        }
        return list;
    }

    @Override
    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public ALCellStringField getSelectedGroup() {
        return this.selected_group;
    }

    public boolean isContains(List<ALEipUser> memberList, ALEipUser user) {
        return ScheduleUtils.isContains(memberList, user);
    }

    protected void setPageParam(int cnt) {
        this.start = this.rows_num * (this.current_page - 1);
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
    }

    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public int getRowsNum() {
        return this.rows_num;
    }

    public int getCount() {
        return this.count;
    }

    public int getPagesNum() {
        return this.pages_num;
    }

    public int getCurrentPage() {
        return this.current_page;
    }

    public int getStart() {
        return this.start;
    }
}

