/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxTermScheduleDayContainer;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTermScheduleWeekContainer
implements ALData {
    private List<AjaxTermScheduleDayContainer> dayList;

    public void initField() {
        this.dayList = new ArrayList<AjaxTermScheduleDayContainer>();
    }

    public void setViewStartDate(Calendar cal) {
        for (int i = 1; i <= 7; ++i) {
            AjaxTermScheduleDayContainer con = new AjaxTermScheduleDayContainer();
            con.initField();
            con.setDate(cal.getTime());
            this.dayList.add(con);
            cal.add(5, 1);
        }
    }

    public void addTermResultData(int index, AjaxScheduleResultData rd) {
        int span = rd.getRowspan();
        AjaxTermScheduleDayContainer con = this.dayList.get(index);
        con.setHasTerm(true);
        con.setTermResultData(rd);
        for (int i = 1; i < span; ++i) {
            con = this.dayList.get(index + i);
            con.setHasTerm(true);
        }
    }

    public boolean canAddTerm(AjaxScheduleResultData rd) {
        boolean canAdd = true;
        Date startDate = rd.getStartDate().getValue();
        Date endDate = rd.getEndDate().getValue();
        int size = this.dayList.size();
        for (int i = 0; i < size; ++i) {
            AjaxTermScheduleDayContainer con = this.dayList.get(i);
            Date conDate = con.getDate().getValue();
            boolean isEmptyStartDate = ScheduleUtils.equalsToDate(ScheduleUtils.getEmptyDate(), startDate, false);
            boolean isEmptyEndDate = ScheduleUtils.equalsToDate(ScheduleUtils.getEmptyDate(), endDate, false);
            if (isEmptyStartDate && isEmptyEndDate) {
                if (!con.isHasTerm()) continue;
                canAdd = false;
                continue;
            }
            if (isEmptyStartDate) {
                if (!ScheduleUtils.equalsToDate(endDate, conDate, false) && !conDate.before(endDate) || !con.isHasTerm()) continue;
                canAdd = false;
                continue;
            }
            if (isEmptyEndDate) {
                if (!ScheduleUtils.equalsToDate(startDate, conDate, false) && !conDate.after(startDate) || !con.isHasTerm()) continue;
                canAdd = false;
                continue;
            }
            if (!ScheduleUtils.equalsToDate(startDate, conDate, false) && !conDate.after(startDate) || !ScheduleUtils.equalsToDate(endDate, conDate, false) && !conDate.before(endDate) || !con.isHasTerm()) continue;
            canAdd = false;
        }
        return canAdd;
    }

    public List<AjaxTermScheduleDayContainer> getDayList() {
        return this.dayList;
    }

    public boolean hasVisibleTerm() {
        for (AjaxTermScheduleDayContainer dayContainer : this.dayList) {
            AjaxScheduleResultData rd;
            if (!dayContainer.isHasTerm() || (rd = dayContainer.getTermResultData()) == null || rd.isPrivate() && !rd.isLoginuser() && !rd.isMember()) continue;
            return true;
        }
        return false;
    }
}

