/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.beans.CellScheduleFormBean;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCellScheduleFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AbstractCellScheduleFormData.class.getName());
    public static final int FLAG_EDIT_REPEAT_DEF = -1;
    public static final int FLAG_EDIT_REPEAT_ALL = 0;
    public static final int FLAG_EDIT_REPEAT_ONE = 1;
    public CellScheduleFormBean form_data;
    private ALCellStringField schedule_type;
    private ALEipUser login_user;
    private ScheduleOnedayGroupSelectData selectData;
    private List<ALEipGroup> groups;
    private boolean is_owner;
    private String tmpStart;
    private String tmpEnd;
    private String tmpView;
    protected String entity_id;
    private String aclPortletFeature;
    private boolean is_first;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.is_owner = true;
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.entity_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        this.aclPortletFeature = "schedule_self";
        this.is_first = !"".equals(rundata.getParameters().getString("is_first", ""));
        super.init(action, rundata, context);
    }

    public void loadParameters(RunData rundata, Context context) {
        ScheduleUtils.loadParametersDelegate(rundata, context, this.tmpStart, this.tmpEnd, this.tmpView);
        this.tmpView = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpView");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.tmpView + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.tmpView + "-00-00"));
        this.tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        this.tmpEnd = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpEnd");
    }

    public void initField() {
        this.form_data = new CellScheduleFormBean();
        this.form_data.initField(this.tmpStart, this.tmpEnd, this.tmpView);
        this.schedule_type = new ALCellStringField();
    }

    protected void setValidator() {
        this.form_data.getMonthDay().setNotNull(true);
        this.form_data.getLimitStartDate().setNotNull(true);
        this.form_data.getLimitEndDate().setNotNull(true);
    }

    protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        return this.form_data.validateDelegate(msgList, this.getLoginUser(), this.entity_id, this.schedule_type.getValue());
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (record == null) {
                return false;
            }
            this.is_owner = record.getOwnerId().longValue() == this.login_user.getUserId().getValue();
            this.schedule_type.setValue(CellScheduleUtils.getScheduleType(record));
            this.form_data.setResultData(record);
            this.loadCustomFormData(record);
            this.setFormData(rundata, context, msgList);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected abstract void loadCustomFormData(EipTSchedule var1);

    public boolean doCheck(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            this.init(action, rundata, context);
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList);
            if (!res) {
                action.setMode("new_form");
            }
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        String st = rundata.getParameters().get("schedule_type");
        if (st != null) {
            this.schedule_type.setValue(st);
        }
        Field[] fields = this.form_data.getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, this.form_data, fields, msgList);
        if (msgList.size() >= 1) {
            return false;
        }
        if (!this.is_first) {
            this.form_data.getMemberList().clear();
            this.form_data.getMemberList().addAll(CellScheduleUtils.getShareUserMemberList(rundata));
        }
        if (!this.isSpan()) {
            Calendar startDate = Calendar.getInstance();
            startDate.setTime(this.form_data.getStartDate().getValue());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(this.form_data.getEndDate().getValue());
            endDate.set(1, startDate.get(1));
            endDate.set(2, startDate.get(2));
            endDate.set(5, startDate.get(5));
            this.form_data.getEndDate().setValue(endDate.getTime());
            if (!this.is_first) {
                this.form_data.getFacilityMemberList().clear();
                this.form_data.getFacilityMemberList().addAll(CellScheduleUtils.getShareFacilityMemberList(rundata));
            }
        }
        return true;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public CellScheduleFormBean getFormData() {
        return this.form_data;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public boolean isFirst() {
        return this.is_first;
    }

    public boolean isOneday() {
        return "O".equals(this.schedule_type.getValue());
    }

    public boolean isSpan() {
        return "S".equals(this.schedule_type.getValue());
    }

    public boolean isRepeat() {
        return "R".equals(this.schedule_type.getValue());
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ScheduleOnedayGroupSelectData getSelectData() {
        return this.selectData;
    }

    public ALCellStringField getScheduleType() {
        return this.schedule_type;
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public int getInt(long num) {
        return (int)num;
    }

    public String getEntityId() {
        return this.entity_id;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

