/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.ALPop3MailReceiveThread;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFolderResultData;
import com.aimluck.eip.webmail.WebMailIndexRowResultData;
import com.aimluck.eip.webmail.WebMailResultData;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import com.sk_jp.mail.MailUtility;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.mail.Address;
import javax.mail.Message;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.om.security.User;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailSelectData
extends ALAbstractSelectData<EipTMail, ALMailMessage> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailSelectData.class.getName());
    private String currentTab = null;
    JetspeedUser user = null;
    private int userId = -1;
    private int accountId = -1;
    private int folderId = -1;
    private Map<Integer, Integer> unreadMailSumMap;
    private final String finalAccessDateStr;
    private String org_id;
    private ALFolder folder;
    private WebMailFolderResultData selectedFolder;
    private List<WebmailAccountLiteBean> mailAccountList;
    private List<WebMailFolderResultData> mailFolderList;

    public WebMailSelectData() {
        this.finalAccessDateStr = null;
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort_type;
        EipMMailAccount account;
        EipTMailFolder mailFolder;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.user = (JetspeedUser)((JetspeedRunData)rundata).getUser();
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"receive");
            this.currentTab = "receive";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        String tmpAccoundId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid");
        if (tmpAccoundId == null || "".equals(tmpAccoundId)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-accounts"));
        }
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"accountid")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)rundata.getParameters().getString("accountid"));
            }
            if (rundata.getParameters().containsKey((Object)"folderid")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folderid", (String)rundata.getParameters().getString("folderid"));
            }
        }
        try {
            this.accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        catch (Exception e) {
            this.accountId = 0;
        }
        try {
            this.folderId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folderid"));
        }
        catch (Exception e) {
            this.folderId = 0;
        }
        if (this.accountId == 0) {
            try {
                Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.userId);
                SelectQuery query = Database.query(EipMMailAccount.class, (Expression)exp);
                query.select("ACCOUNT_ID");
                List accounts = query.fetchList();
                if (accounts == null || accounts.size() <= 0) {
                    return;
                }
                EipMMailAccount account2 = (EipMMailAccount)accounts.get(0);
                this.accountId = account2.getAccountId();
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)Integer.toString(this.accountId));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((mailFolder = WebMailUtils.getEipTMailFolder(account = ALMailUtils.getMailAccount((String)this.org_id, (int)this.userId, (int)this.accountId), String.valueOf(this.folderId))) == null) {
            this.folderId = account.getDefaultFolderId();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folderid", (String)String.valueOf(this.folderId));
            mailFolder = WebMailUtils.getEipTMailFolder(account, String.valueOf(this.folderId));
        }
        this.selectedFolder = new WebMailFolderResultData(mailFolder);
        this.mailFolderList = WebMailUtils.getMailFolderAll(account);
        if (this.accountId > 0) {
            int type_mail = "receive".equals(this.currentTab) ? 1 : 2;
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            this.folder = handler.getALFolder(type_mail, this.org_id, this.userId, Integer.valueOf(this.accountId).intValue());
            this.folder.setRowsNum(super.getRowsNum());
        }
        super.init(action, rundata, context);
        if ("date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && ((sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR)) == null || sort_type.equals(""))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
    }

    public void loadMailAccountList(RunData rundata, Context context) {
        try {
            this.mailAccountList = new ArrayList<WebmailAccountLiteBean>();
            List<EipMMailAccount> aList = WebMailUtils.getMailAccountNameList(ALEipUtils.getUserId((RunData)rundata));
            if (aList == null) {
                return;
            }
            WebmailAccountLiteBean bean = null;
            for (EipMMailAccount account : aList) {
                bean = new WebmailAccountLiteBean();
                bean.initField();
                bean.setAccountId(account.getAccountId());
                bean.setAccountName(account.getAccountName());
                this.mailAccountList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected ResultList<EipTMail> selectList(RunData rundata, Context context) {
        try {
            if (this.folder == null) {
                return null;
            }
            String unreadMailSumMapString = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"unreadmailsummap");
            this.unreadMailSumMap = (rundata.getParameters().containsKey((Object)"noupdateunread") || rundata.getParameters().containsKey((Object)"sort") || rundata.getParameters().containsKey((Object)"tab")) && unreadMailSumMapString != null && !rundata.getParameters().containsKey((Object)"updateunread") ? WebMailUtils.getUnreadMailSumMapFromString(unreadMailSumMapString) : WebMailUtils.getUnreadMailNumberMap(rundata, this.userId, this.accountId);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"unreadmailsummap", (String)this.unreadMailSumMap.toString());
            return this.folder.getIndexRows(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected ALMailMessage selectDetail(RunData rundata, Context context) {
        String mailid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (mailid == null || Integer.valueOf(mailid) == null) {
            logger.debug((Object)"[Mail] Empty ID...");
            return null;
        }
        return this.folder.getMail(Integer.valueOf(mailid).intValue());
    }

    protected Object getResultData(EipTMail record) {
        WebMailIndexRowResultData rd = new WebMailIndexRowResultData();
        rd.initField();
        rd.setMailId(record.getMailId().toString());
        String isRead = record.getReadFlg();
        if ("T".equals(isRead)) {
            rd.setReadImage("themes/" + this.getTheme() + "/images/icon/webmail_readmail.gif");
            rd.setReadImageDescription("\u65e2\u8aad");
        } else {
            rd.setReadImage("themes/" + this.getTheme() + "/images/icon/webmail_unreadmail.gif");
            rd.setReadImageDescription("\u672a\u8aad");
        }
        String subject = ALMailUtils.decodeSubject((String)record.getSubject());
        rd.setSubject(ALCommonUtils.compressString((String)subject, (int)this.getStrLength()));
        rd.setPerson(MailUtility.decodeText((String)record.getPerson()));
        rd.setDate(record.getEventDate());
        rd.setFileVolume(record.getFileVolume().toString());
        boolean hasAttachments = "T".equals(record.getHasFiles());
        if (hasAttachments) {
            rd.setWithFilesImage("images/webmail/webmail_withfiles.gif");
            rd.setWithFilesImageDescription("\u6dfb\u4ed8\u6709");
        }
        rd.hasAttachments(hasAttachments);
        return rd;
    }

    protected Object getResultDataDetail(ALMailMessage obj) {
        WebMailResultData rd = null;
        try {
            ALLocalMailMessage msg = (ALLocalMailMessage)obj;
            String date = "";
            Date sentDate = msg.getSentDate();
            date = sentDate == null ? "Unknown" : ALMailUtils.translateDate((Date)sentDate);
            rd = new WebMailResultData();
            rd.initField();
            rd.setHeaders(msg.getHeaderArray());
            rd.setSubject(msg.getSubject());
            rd.setFrom(ALMailUtils.getAddressString((Address[])msg.getFrom()));
            rd.setTo(ALMailUtils.getAddressString((Address[])msg.getRecipients(Message.RecipientType.TO)));
            rd.setDate(date);
            rd.setBody(msg.getBodyText());
            rd.setAttachmentFileNames(msg.getAttachmentFileNameArray());
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        return rd;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public List<WebMailFolderResultData> getFolderList() {
        return this.mailFolderList;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public List<WebmailAccountLiteBean> getMailAccountList() {
        return this.mailAccountList;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public WebMailFolderResultData getSelectedFolder() {
        return this.selectedFolder;
    }

    public int getNewMailSum() {
        try {
            return WebMailUtils.getNewMailNumThread(this.org_id, this.user, this.accountId);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getUnReadMailSumByFolderId(int folder_id) {
        return this.unreadMailSumMap.get(folder_id);
    }

    public String getFinalAccessDate() {
        return this.finalAccessDateStr;
    }

    public int getRowsNum() {
        return this.folder.getRowsNum();
    }

    public int getCount() {
        return this.folder.getCount();
    }

    public int getPagesNum() {
        return this.folder.getPagesNum();
    }

    public int getCurrentPage() {
        return this.folder.getCurrentPage();
    }

    public String getCurrentSort() {
        return this.folder.getCurrentSort();
    }

    public String getCurrentSortType() {
        return this.folder.getCurrentSortType();
    }

    public int getStart() {
        return this.folder.getStart();
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getStatStr() {
        return ALPop3MailReceiveThread.getReceiveMailResultStr((User)this.user, (int)this.accountId);
    }
}

