/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFormData.class.getName());
    private final int FIELD_SUBJECT_MAX_LEN = 256;
    private final int FIELD_RECIPIENT_MAX_LEN = 512;
    private final int FIELD_BODY_MAX_LEN = 50000;
    public static final int TYPE_DEF_MAIL = -1;
    public static final int TYPE_NEW_MAIL = 0;
    public static final int TYPE_REPLY_MAIL = 1;
    public static final int TYPE_FORWARD_MAIL = 2;
    public static final int TYPE_REPLY_ALL_MAIL = 3;
    private ALNumberField mailType = null;
    private ALStringField to = null;
    private ALStringField cc = null;
    private ALStringField bcc = null;
    private ALStringField subject = null;
    private ALStringField body = null;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int userId = -1;
    private int accountId = -1;
    private String org_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        try {
            this.accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        catch (Exception e) {
            this.accountId = 0;
        }
        this.folderName = rundata.getParameters().getString("folderName");
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
    }

    public void initField() {
        this.mailType = new ALNumberField();
        this.mailType.setFieldName("\u30bf\u30a4\u30d7");
        this.to = new ALStringField();
        this.to.setFieldName("\u5b9b\u5148");
        this.to.setTrim(true);
        this.cc = new ALStringField();
        this.cc.setFieldName("CC");
        this.cc.setTrim(true);
        this.bcc = new ALStringField();
        this.bcc.setFieldName("BCC");
        this.bcc.setTrim(true);
        this.subject = new ALStringField();
        this.subject.setFieldName("\u4ef6\u540d");
        this.subject.setTrim(true);
        this.body = new ALStringField();
        this.body.setFieldName("\u672c\u6587");
        this.body.setTrim(false);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected void setValidator() {
        this.to.setNotNull(true);
        this.to.limitMaxLength(512);
        this.cc.limitMaxLength(512);
        this.bcc.limitMaxLength(512);
        this.subject.limitMaxLength(256);
        this.body.limitMaxLength(50000);
    }

    public boolean validate(List<String> msgList) {
        String delim = ",";
        if (this.to.validate(msgList) && !WebMailUtils.checkAddress(this.to.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>\u5b9b\u5148</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.cc.validate(msgList) && this.cc.getValue().trim().length() > 0 && !WebMailUtils.checkAddress(this.cc.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>CC</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.bcc.validate(msgList) && this.bcc.getValue().trim().length() > 0 && !WebMailUtils.checkAddress(this.bcc.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>BCC</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.subject.validate(msgList);
        this.body.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int index;
            try {
                index = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            }
            catch (Exception e) {
                return false;
            }
            String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
            int type_mail = "receive".equals(currentTab) ? 1 : 2;
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALFolder folder = handler.getALFolder(type_mail, this.org_id, this.userId, Integer.valueOf(this.accountId).intValue());
            folder.deleteMail(index);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        block20: {
            String[] attachmentFilepaths = null;
            try {
                ALSmtpMailContext mailcontext;
                ALMailSenderContext scontext;
                boolean hasAttachments;
                FileuploadLiteBean filebean = null;
                File file = null;
                boolean bl = hasAttachments = this.fileuploadList != null && this.fileuploadList.size() > 0;
                if (hasAttachments) {
                    int size = this.fileuploadList.size();
                    attachmentFilepaths = new String[size];
                    for (int i = 0; i < size; ++i) {
                        filebean = this.fileuploadList.get(i);
                        file = FileuploadUtils.getAbsolutePath((String)this.org_id, (int)this.userId, (String)this.folderName, (int)filebean.getFileId());
                        attachmentFilepaths[i] = file.getAbsolutePath();
                    }
                }
                if (this.subject.getValue() == null || this.subject.getValue().equals("")) {
                    this.subject.setValue("\u7121\u984c");
                }
                LinkedHashMap<String, String> map = null;
                if (this.getMailType().getValue() == 1L || this.getMailType().getValue() == 3L) {
                    ALLocalMailMessage msg = null;
                    try {
                        msg = (ALLocalMailMessage)WebMailUtils.getSelectedLocalMailMessage(rundata, context, (int)this.getMailType().getValue());
                        if (msg == null) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    String in_reply_tos = msg.getMessageID();
                    StringBuffer reference = new StringBuffer();
                    String[] references = msg.getHeader("References");
                    map = new LinkedHashMap<String, String>();
                    if (references != null && references.length > 0) {
                        reference.append(ALMailUtils.getOneString((String[])references, (String)" "));
                    }
                    if (in_reply_tos != null && !in_reply_tos.equals("")) {
                        map.put("In-Reply-To", in_reply_tos);
                        reference.append(" ").append(in_reply_tos);
                    }
                    if (reference.toString() != null || !reference.toString().equals("")) {
                        map.put("References", reference.toString());
                    }
                }
                if (map != null && map.size() == 0) {
                    map = null;
                }
                String delim = ",";
                EipMMailAccount account = ALMailUtils.getMailAccount(null, (int)this.userId, (int)this.accountId);
                ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
                int success_send = handler.send(scontext = ALMailUtils.getALSmtpMailSenderContext((String)this.org_id, (EipMMailAccount)account), (ALMailContext)(mailcontext = ALMailUtils.getALSmtpMailContext((String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.to.getValue()), (String)delim), (String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.cc.getValue()), (String)delim), (String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.bcc.getValue()), (String)delim), (String)account.getMailAddress(), (String)ALStringUtil.unsanitizing((String)account.getMailUserName()), (String)ALStringUtil.unsanitizing((String)this.subject.getValue()), (String)ALStringUtil.unsanitizing((String)this.body.getValue()), (String[])attachmentFilepaths, map)));
                if (success_send == 0) {
                    if (hasAttachments) {
                        File folder = FileuploadUtils.getFolder((String)this.org_id, (int)this.userId, (String)this.folderName);
                        FileuploadUtils.deleteFolder((File)folder);
                    }
                    break block20;
                }
                if (success_send == 1) {
                    msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u8a2d\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                } else if (success_send == 2) {
                    msgList.add("7MB \u3092\u8d85\u3048\u308b\u30b5\u30a4\u30ba\u306e\u30e1\u30fc\u30eb\u306f\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002");
                } else if (success_send == 5) {
                    msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
                msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u8a2d\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                return false;
            }
        }
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String[] filenames;
            Address[] tos;
            ALLocalMailMessage msg = (ALLocalMailMessage)WebMailUtils.getSelectedLocalMailMessage(rundata, context, (int)this.getMailType().getValue());
            if (msg == null) {
                return false;
            }
            this.mailType.setValue((long)rundata.getParameters().getInt("mailtype", 0));
            String tmpSubject = null;
            if (this.getMailType().getValue() == 0L) {
                tos = msg.getRecipients(Message.RecipientType.TO);
                this.setTo(ALMailUtils.getAddressString((Address[])tos));
                Address[] ccs = msg.getRecipients(Message.RecipientType.CC);
                this.setCc(ALMailUtils.getAddressString((Address[])ccs));
                Address[] bccs = msg.getRecipients(Message.RecipientType.BCC);
                this.setBcc(ALMailUtils.getAddressString((Address[])bccs));
                tmpSubject = msg.getSubject();
            } else if (this.getMailType().getValue() == 1L) {
                tos = msg.getFrom();
                this.setTo(ALMailUtils.getAddressString((Address[])tos));
                tmpSubject = "Re: " + msg.getSubject();
            } else if (this.getMailType().getValue() == 2L) {
                tmpSubject = "Fwd: " + msg.getSubject();
            } else if (this.getMailType().getValue() == 3L) {
                int i;
                Address[] from = msg.getFrom();
                Address[] to = msg.getRecipients(Message.RecipientType.TO);
                int from_length = from.length;
                int to_length = to.length;
                Address[] tos2 = new Address[from_length + to_length];
                for (i = 0; i < from_length; ++i) {
                    tos2[i] = from[i];
                }
                for (i = 0; i < to_length; ++i) {
                    tos2[i + from_length] = to[i];
                }
                this.setTo(ALMailUtils.getAddressString((Address[])tos2));
                Address[] ccs = msg.getRecipients(Message.RecipientType.CC);
                this.setCc(ALMailUtils.getAddressString((Address[])ccs));
                Address[] bccs = msg.getRecipients(Message.RecipientType.BCC);
                this.setBcc(ALMailUtils.getAddressString((Address[])bccs));
                tmpSubject = "Re: " + msg.getSubject();
            }
            this.setSubject(tmpSubject);
            String[] tmp2 = msg.getBodyTextArray();
            StringBuffer replies = new StringBuffer();
            replies.append("\r\n\r\n\r\n------Original Message-------\r\n");
            for (String factor : tmp2) {
                replies.append("> " + factor + "\r\n");
            }
            try {
                EipMMailAccount account = ALMailUtils.getMailAccount(null, (int)this.userId, (int)this.accountId);
                if (account.getSignature() != null && !"".equals(account.getSignature())) {
                    this.body.setValue(replies + "\r\n\r\n\r\n" + account.getSignature());
                } else {
                    this.body.setValue(replies.toString());
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
            if (this.getMailType().getValue() == 2L && (filenames = msg.getAttachmentFileNameArray()) != null && filenames.length > 0) {
                File rootFolder;
                File saveFolder;
                if (this.folderName == null || this.folderName.equals("")) {
                    this.folderName = "undefined";
                }
                if (!(saveFolder = new File((rootFolder = FileuploadUtils.getRootFolder((String)this.org_id, (int)this.userId)) + File.separator + this.folderName)).exists()) {
                    saveFolder.mkdirs();
                }
                for (int i = 0; i < filenames.length; ++i) {
                    String newAttachmentFileName = this.getNewAttachmentFileName(saveFolder);
                    int fileId = Integer.parseInt(newAttachmentFileName);
                    String realfilename = filenames[i];
                    String filepath = rootFolder + File.separator + this.folderName + File.separator + newAttachmentFileName;
                    File file = new File(filepath);
                    file.createNewFile();
                    InputStream inputStream = msg.getInputStream(i);
                    FileOutputStream fileOutput = new FileOutputStream(file);
                    byte[] b = new byte[1024];
                    int len = -1;
                    while ((len = inputStream.read(b)) != -1) {
                        fileOutput.write(b, 0, len);
                        fileOutput.flush();
                    }
                    fileOutput.close();
                    inputStream.close();
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath + ".txt"), FileuploadUtils.FILE_ENCODING));
                    writer.println(realfilename);
                    writer.flush();
                    writer.close();
                    FileuploadLiteBean filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFileId(fileId);
                    filebean.setFileName(realfilename);
                    filebean.setFolderName(this.folderName);
                    this.fileuploadList.add(filebean);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (this.accountId <= 0 || this.userId <= 0) {
            return res;
        }
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
            EipMMailAccount account = ALMailUtils.getMailAccount(null, (int)this.userId, (int)this.accountId);
            if (!"insert".equals(rundata.getParameters().get("mode")) && account.getSignature() != null && !"".equals(account.getSignature())) {
                StringBuffer bodybuf = new StringBuffer();
                if (this.body.getValue() != null) {
                    bodybuf.append(this.body.getValue());
                }
                bodybuf.append("\r\n\r\n\r\n");
                bodybuf.append(account.getSignature());
                this.body.setValue(bodybuf.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return res;
    }

    public ALStringField getBcc() {
        return this.bcc;
    }

    public ALStringField getBody() {
        return this.body;
    }

    public ALStringField getCc() {
        return this.cc;
    }

    public ALStringField getSubject() {
        return this.subject;
    }

    public ALStringField getTo() {
        return this.to;
    }

    public ALNumberField getMailType() {
        return this.mailType;
    }

    public void setMailType(int field) {
        this.mailType.setValue((long)field);
    }

    public void setBcc(String string) {
        this.bcc.setValue(string);
    }

    public void setBody(String string) {
        this.body.setValue(string);
    }

    public void setCc(String string) {
        this.cc.setValue(string);
    }

    public void setSubject(String string) {
        this.subject.setValue(string);
    }

    public void setTo(String string) {
        this.to.setValue(string);
    }

    public String getAccountName() {
        return ALMailUtils.getAccountName((int)this.userId, (int)this.accountId);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getAddrForCell(ALStringField addrs_filed) {
        if (addrs_filed == null) {
            return "";
        }
        String addrs = addrs_filed.getValue();
        if (addrs == null || addrs.length() == 0) {
            return "";
        }
        StringBuffer addrbuf = new StringBuffer();
        int count = 0;
        String token = null;
        StringTokenizer st = new StringTokenizer(addrs, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            token = st.nextToken();
            if (token.indexOf("<") == -1) {
                addrbuf.append(token);
            } else {
                StringTokenizer tmp_st = new StringTokenizer(token, "<>");
                if (tmp_st.countTokens() == 2) {
                    tmp_st.nextToken();
                    addrbuf.append(tmp_st.nextToken());
                }
            }
            if (++count >= size) continue;
            addrbuf.append(",");
        }
        return addrbuf.toString();
    }

    private String getNewAttachmentFileName(File folder) {
        int maxNum = 1;
        String[] filenames = folder.list();
        File file = null;
        int tmpInt = 1;
        int length = filenames.length;
        for (int i = 0; i < length; ++i) {
            file = new File(folder.getAbsolutePath() + File.separator + filenames[i]);
            if (!file.isFile() || file.getName().endsWith(".txt")) continue;
            try {
                tmpInt = Integer.parseInt(file.getName());
                if (maxNum > tmpInt) continue;
                maxNum = tmpInt + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Integer.toString(maxNum);
    }
}

