/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFolderResultData;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.Date;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailFolderSelectData
extends ALAbstractSelectData<EipTMailFolder, EipTMailFolder> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFolderSelectData.class.getName());
    String folder_id = null;
    private EipMMailAccount mail_account;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"folderid")) {
                this.folder_id = rundata.getParameters().get("folderid");
            }
            mailAccountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        ALEipUser login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mail_account = ALMailUtils.getMailAccount((String)"", (int)((int)login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mail_account == null) {
            return;
        }
        EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mail_account, this.folder_id);
        if (folder == null) {
            logger.error((Object)"[WebMail Folder] mail folder was not found.");
            return;
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipTMailFolder> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected EipTMailFolder selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTMailFolder folder = WebMailUtils.getEipTMailFolder(rundata, context);
        return folder;
    }

    protected Object getResultData(EipTMailFolder obj) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultDataDetail(EipTMailFolder record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.folder_id = record.getFolderId().toString();
            WebMailFolderResultData rd = new WebMailFolderResultData();
            rd.initField();
            rd.setFolderId(record.getFolderId());
            rd.setFolderName(record.getFolderName());
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            if (this.mail_account.getDefaultFolderId().equals(record.getFolderId())) {
                rd.setCanUpdate(false);
            } else {
                rd.setCanUpdate(true);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public String getFolderId() {
        return this.folder_id;
    }

    public String getAclPortletFeature() {
        return "cabinet_folder";
    }
}

