/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailFolderFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFolderFormData.class.getName());
    private ALStringField folder_name;
    private ALNumberField access_flag;
    private ALEipUser login_user;
    private EipMMailAccount mailAccount;
    private String folderId = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTMailFolder folder;
        super.init(action, rundata, context);
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            String entityId;
            try {
                mailAccountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
            }
            catch (Exception e) {
                return;
            }
            if (rundata.getParameters().containsKey((Object)"entityid") && !"new".equals(entityId = rundata.getParameters().getString("entityid"))) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)entityId);
                this.folderId = entityId;
            }
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mailAccount = ALMailUtils.getMailAccount((String)"", (int)((int)this.login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mailAccount == null) {
            return;
        }
        if (this.folderId != null && (folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId)) == null) {
            logger.error((Object)"[WebMail Folder] mail folder was not found.");
            return;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res && "update".equals(this.getMode())) {
            this.folderId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folderid");
        }
        return res;
    }

    public void initField() {
        this.folder_name = new ALStringField();
        this.folder_name.setFieldName("\u30d5\u30a9\u30eb\u30c0\u540d");
        this.folder_name.setTrim(true);
    }

    protected void setValidator() {
        this.folder_name.setNotNull(true);
        this.folder_name.limitMaxLength(128);
    }

    protected boolean validate(List<String> msgList) {
        this.folder_name.validate(msgList);
        if (this.existsFolderName(this.folder_name.getValue(), "update".equals(this.getMode()))) {
            msgList.add("\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u540d\u3068\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u304c\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    private boolean existsFolderName(String fname, boolean is_update) {
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            Expression exp2;
            List list;
            SelectQuery query = Database.query(EipTMailFolder.class);
            Expression exp = ExpressionFactory.matchExp((String)"folderName", (Object)fname);
            if (is_update) {
                exp = exp.andExp(ExpressionFactory.noMatchDbExp((String)"FOLDER_ID", (Object)this.folderId));
            }
            if ((list = query.setQualifier(exp.andExp(exp2 = ExpressionFactory.matchExp((String)"eipMMailAccount", (Object)this.mailAccount))).fetchList()) != null && list.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId);
            if (folder == null) {
                return false;
            }
            this.folder_name.setValue(folder.getFolderName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Expression exp;
            String folderId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folderid");
            if (this.mailAccount.getDefaultFolderId() == Integer.parseInt(folderId)) {
                return false;
            }
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, folderId);
            List folderMails = ALMailUtils.getEipTMails((EipTMailFolder)folder);
            SelectQuery query = Database.query(EipTMailFilter.class);
            List filters = query.setQualifier(exp = ExpressionFactory.matchDbExp((String)"eipTMailFolder", (Object)folder)).fetchList();
            if (filters != null && filters.size() != 0) {
                EipTMailFolder defaultFolder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.mailAccount.getDefaultFolderId().toString());
                for (EipTMailFilter filter : filters) {
                    filter.setEipTMailFolder(defaultFolder);
                }
            }
            ArrayList<String> mailPaths = new ArrayList<String>();
            if (folderMails != null && folderMails.size() > 0) {
                for (EipTMail mail : folderMails) {
                    mailPaths.add(mail.getFilePath());
                }
            }
            Database.delete((Persistent)folder);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, folder.getFolderName());
            if (mailPaths.size() > 0) {
                File file = null;
                int size = mailPaths.size();
                for (int k = 0; k < size; ++k) {
                    file = new File(ALMailUtils.getLocalurl() + (String)mailPaths.get(k));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = (EipTMailFolder)Database.create(EipTMailFolder.class);
            folder.setFolderName(this.folder_name.getValue());
            folder.setCreateDate(Calendar.getInstance().getTime());
            folder.setUpdateDate(Calendar.getInstance().getTime());
            folder.setEipMMailAccount(this.mailAccount);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, this.folder_name.getValue());
            return true;
        }
        catch (Throwable t) {
            logger.error((Object)t);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId);
            if (folder == null) {
                return false;
            }
            folder.setFolderName(this.folder_name.getValue());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, this.folder_name.getValue());
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
    }

    public EipMMailAccount getMailAccount() {
        return this.mailAccount;
    }

    public ALStringField getFolderName() {
        return this.folder_name;
    }

    public ALNumberField getAccessFlag() {
        return this.access_flag;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

