/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFilterResultData;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailFilterSelectData
extends ALAbstractSelectData<EipTMailFilter, EipTMailFilter> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFilterSelectData.class.getName());
    String filterId = null;
    private EipMMailAccount mailAccount;
    private List<WebmailAccountLiteBean> mailAccountList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int mailAccountId = 0;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort_order");
        }
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            try {
                if (rundata.getParameters().containsKey((Object)"filterid")) {
                    this.filterId = rundata.getParameters().get("filterid");
                }
                mailAccountId = rundata.getParameters().containsKey((Object)"accountid") ? Integer.parseInt(rundata.getParameters().get("accountid")) : Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ALEipUser login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mailAccount = ALMailUtils.getMailAccount(null, (int)((int)login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mailAccount == null) {
            try {
                SelectQuery query = Database.query(EipMMailAccount.class);
                Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)login_user.getUserId());
                EipMMailAccount account = (EipMMailAccount)query.setQualifier(exp).fetchSingle();
                if (account == null) {
                    return;
                }
                this.mailAccount = account;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)this.mailAccount.getAccountId().toString());
        super.init(action, rundata, context);
    }

    public void loadMailAccountList(RunData rundata, Context context) {
        try {
            this.mailAccountList = new ArrayList<WebmailAccountLiteBean>();
            List<EipMMailAccount> aList = WebMailUtils.getMailAccountNameList(ALEipUtils.getUserId((RunData)rundata));
            if (aList == null) {
                return;
            }
            WebmailAccountLiteBean bean = null;
            for (EipMMailAccount account : aList) {
                bean = new WebmailAccountLiteBean();
                bean.initField();
                bean.setAccountId(account.getAccountId());
                bean.setAccountName(account.getAccountName());
                this.mailAccountList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected ResultList<EipTMailFilter> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            SelectQuery<EipTMailFilter> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTMailFilter> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTMailFilter.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)this.mailAccount);
        query.setQualifier(exp);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipTMailFilter selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTMailFilter filter = WebMailUtils.getEipTMailFilter(this.mailAccount, this.filterId);
        return filter;
    }

    protected Object getResultData(EipTMailFilter record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.filterId = record.getFilterId().toString();
            WebMailFilterResultData rd = new WebMailFilterResultData();
            Map typeMap = ALMailUtils.getMailFilterTypeMap();
            rd.initField();
            rd.setFilterId(record.getFilterId().longValue());
            rd.setSortOrder(record.getSortOrder().longValue());
            rd.setFilterName(record.getFilterName());
            rd.setFilterType((String)typeMap.get(record.getFilterType()));
            rd.setFilterString(record.getFilterString());
            rd.setDstFolderName(record.getEipTMailFolder().getFolderName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTMailFilter record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.filterId = record.getFilterId().toString();
            WebMailFilterResultData rd = new WebMailFilterResultData();
            Map typeMap = ALMailUtils.getMailFilterTypeMap();
            rd.initField();
            rd.setFilterId(record.getFilterId().longValue());
            rd.setSortOrder(record.getSortOrder().longValue());
            rd.setFilterName(record.getFilterName());
            rd.setFilterType((String)typeMap.get(record.getFilterType()));
            rd.setFilterString(record.getFilterString());
            rd.setDstFolderName(record.getEipTMailFolder().getFolderName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("sort_order", "sortOrder");
        map.putValue("filter_name", "filterName");
        map.putValue("filter_string", "filterType");
        map.putValue("dst_folder_name", "eipTMailFolder.folderName");
        return map;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public int getAccountId() {
        return this.mailAccount.getAccountId();
    }

    public List<WebmailAccountLiteBean> getMailAccountList() {
        return this.mailAccountList;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

