/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFolderResultData;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailFilterFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFilterFormData.class.getName());
    private ALStringField filter_name;
    private ALStringField filter_string;
    private ALStringField filter_type;
    private ALNumberField dst_folder_id;
    private ALEipUser login_user;
    private String filterId;
    private EipMMailAccount mailAccount;
    private List<WebMailFolderResultData> folderList;
    private Map<String, String> typeList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            try {
                mailAccountId = rundata.getParameters().containsKey((Object)"accountid") ? Integer.parseInt(rundata.getParameters().get("accountid")) : Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
                this.filterId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
            catch (Exception e) {
                return;
            }
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mailAccount = ALMailUtils.getMailAccount(null, (int)((int)this.login_user.getUserId().getValue()), (int)mailAccountId);
        this.typeList = ALMailUtils.getMailFilterTypeMap();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        this.loadMailFolderList(rundata, context);
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    public void initField() {
        this.filter_name = new ALStringField();
        this.filter_name.setFieldName("\u30d5\u30a3\u30eb\u30bf\u540d");
        this.filter_name.setTrim(true);
        this.filter_string = new ALStringField();
        this.filter_string.setFieldName("\u632f\u308a\u5206\u3051\u6761\u4ef6");
        this.filter_string.setTrim(true);
        this.filter_type = new ALStringField();
        this.filter_type.setTrim(true);
        this.dst_folder_id = new ALNumberField();
        this.dst_folder_id.setFieldName("\u632f\u308a\u5206\u3051\u5148");
        this.folderList = new ArrayList<WebMailFolderResultData>();
    }

    protected void setValidator() {
        this.filter_name.setNotNull(true);
        this.filter_name.limitMaxLength(128);
        this.filter_string.setNotNull(true);
        this.filter_string.limitMaxLength(128);
    }

    protected boolean validate(List<String> msgList) {
        this.filter_name.validate(msgList);
        this.filter_string.validate(msgList);
        this.dst_folder_id.validate(msgList);
        if (this.existsFilterName(this.filter_name.getValue(), "update".equals(this.getMode()))) {
            msgList.add("\u3053\u306e\u30d5\u30a3\u30eb\u30bf\u540d\u3068\u540c\u3058\u30d5\u30a3\u30eb\u30bf\u304c\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a3\u30eb\u30bf\u540d\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    private boolean existsFilterName(String fname, boolean is_update) {
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            Expression exp2;
            List list;
            SelectQuery query = Database.query(EipTMailFilter.class);
            Expression exp = ExpressionFactory.matchExp((String)"filterName", (Object)fname);
            if (is_update) {
                exp = exp.andExp(ExpressionFactory.noMatchDbExp((String)"FILTER_ID", (Object)this.filterId));
            }
            if ((list = query.setQualifier(exp.andExp(exp2 = ExpressionFactory.matchExp((String)"eipMMailAccount", (Object)this.mailAccount))).fetchList()) != null && list.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String filterId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            EipTMailFilter filter = WebMailUtils.getEipTMailFilter(this.mailAccount, filterId);
            if (filter == null) {
                return false;
            }
            this.filter_name.setValue(filter.getFilterName());
            this.filter_string.setValue(filter.getFilterString());
            this.filter_type.setValue(filter.getFilterType());
            this.dst_folder_id.setValue((long)filter.getEipTMailFolder().getFolderId().intValue());
            this.loadMailFolderList(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String filterId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            EipTMailFilter filter = WebMailUtils.getEipTMailFilter(this.mailAccount, filterId);
            int sortOrder = filter.getSortOrder();
            SelectQuery query = Database.query(EipTMailFilter.class);
            Expression exp = ExpressionFactory.matchExp((String)"eipMMailAccount", (Object)filter.getEipMMailAccount());
            Expression exp2 = ExpressionFactory.greaterOrEqualExp((String)"sortOrder", (Object)(sortOrder + 1));
            List filters = query.setQualifier(exp.andExp(exp2)).fetchList();
            for (EipTMailFilter correct_filter : filters) {
                correct_filter.setSortOrder(Integer.valueOf(correct_filter.getSortOrder() - 1));
            }
            Database.delete((Persistent)filter);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(filter.getFilterId().intValue(), 233, filter.getFilterName());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder mailFolder = WebMailUtils.getEipTMailFolder(this.mailAccount, String.valueOf(this.dst_folder_id.getValue()));
            EipTMailFilter filter = (EipTMailFilter)Database.create(EipTMailFilter.class);
            filter.setFilterName(this.filter_name.getValue());
            filter.setFilterString(this.filter_string.getValue());
            filter.setFilterType(this.filter_type.getValue());
            filter.setEipTMailFolder(mailFolder);
            filter.setEipMMailAccount(this.mailAccount);
            filter.setSortOrder(Integer.valueOf(WebMailUtils.getMailFilterLastSortOrder(this.mailAccount) + 1));
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(filter.getFilterId().intValue(), 233, this.filter_name.getValue());
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String filterId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            EipTMailFilter filter = WebMailUtils.getEipTMailFilter(this.mailAccount, filterId);
            if (filter == null) {
                return false;
            }
            EipTMailFolder mailFolder = WebMailUtils.getEipTMailFolder(this.mailAccount, String.valueOf(this.dst_folder_id.getValue()));
            filter.setFilterName(this.filter_name.getValue());
            filter.setFilterString(this.filter_string.getValue());
            filter.setFilterType(this.filter_type.getValue());
            filter.setEipTMailFolder(mailFolder);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(filter.getFilterId().intValue(), 233, this.filter_name.getValue());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    public void loadMailFolderList(RunData rundata, Context context) {
        if (this.mailAccount == null) {
            return;
        }
        try {
            List mailFolders = ALMailUtils.getEipTMailFolderAll((EipMMailAccount)this.mailAccount);
            for (EipTMailFolder folder : mailFolders) {
                WebMailFolderResultData rd = new WebMailFolderResultData();
                rd.initField();
                rd.setFolderId(folder.getFolderId().longValue());
                rd.setFolderName(folder.getFolderName());
                this.folderList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public EipMMailAccount getMailAccount() {
        return this.mailAccount;
    }

    public ALStringField getFilterName() {
        return this.filter_name;
    }

    public ALStringField getFilterString() {
        return this.filter_string;
    }

    public String getFilterType() {
        return this.filter_type.getValue();
    }

    public ALNumberField getDstFolderId() {
        return this.dst_folder_id;
    }

    public List<WebMailFolderResultData> getFolderList() {
        return this.folderList;
    }

    public Map<String, String> getTypeList() {
        return this.typeList;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

