/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserEmailLiteBean;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserGroupLiteBean;
import com.aimluck.eip.addressbookuser.util.AddressBookUserUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMailAddressbookFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailAddressbookFormData.class.getName());
    public static final int TYPE_EXTERNAL = 0;
    public static final int TYPE_INTERNAL = 1;
    private ALStringField type_company = null;
    private List<ALEipGroup> internalGroupList = null;
    private List<AddressBookUserGroupLiteBean> externalGroupList = null;
    private ALStringField current_internal_group_name = null;
    private ALStringField current_external_group_name = null;
    private ArrayList<ALStringField> toRecipientList = null;
    private ArrayList<ALStringField> ccRecipientList = null;
    private ArrayList<ALStringField> bccRecipientList = null;
    private int userId = -1;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.internalGroupList = new ArrayList<ALEipGroup>();
        if (myGroups != null) {
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.internalGroupList.add((ALEipGroup)myGroups.get(i));
            }
        }
        this.externalGroupList = AddressBookUserUtils.getAddressBookUserGroupLiteBeans((RunData)rundata);
        this.toRecipientList = new ArrayList();
        this.ccRecipientList = new ArrayList();
        this.bccRecipientList = new ArrayList();
        try {
            String[] detail_bcc_recipients;
            String[] detail_cc_recipients;
            String[] detail_to_recipients = rundata.getParameters().getStrings("detail_to_recipients");
            if (detail_to_recipients != null) {
                int length = detail_to_recipients.length;
                for (int i = 0; i < length; ++i) {
                    this.toRecipientList.add(new ALStringField(new String(detail_to_recipients[i].getBytes("8859_1"), "utf-8")));
                }
            }
            if ((detail_cc_recipients = rundata.getParameters().getStrings("detail_cc_recipients")) != null) {
                int length = detail_cc_recipients.length;
                for (int i = 0; i < length; ++i) {
                    this.ccRecipientList.add(new ALStringField(new String(detail_cc_recipients[i].getBytes("8859_1"), "utf-8")));
                }
            }
            if ((detail_bcc_recipients = rundata.getParameters().getStrings("detail_bcc_recipients")) != null) {
                int length = detail_bcc_recipients.length;
                for (int i = 0; i < length; ++i) {
                    this.bccRecipientList.add(new ALStringField(new String(detail_bcc_recipients[i].getBytes("8859_1"), "utf-8")));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected void setValidator() {
        this.current_internal_group_name.setNotNull(true);
        this.current_external_group_name.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        return msgList.size() == 0;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                String[] str = rundata.getParameters().getStrings("detail_recipients");
                if (str == null) {
                    return res;
                }
                ALStringField field = null;
                int size = str.length;
                for (int i = 0; i < size; ++i) {
                    field = new ALStringField();
                    field.setValue(ALStringUtil.unsanitizing((String)new String(str[i].getBytes("8859_1"), "UTF-8")));
                    this.toRecipientList.add(field);
                    this.ccRecipientList.add(field);
                    this.bccRecipientList.add(field);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = false;
        try {
            res = this.setFormData(rundata, context, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public void initField() {
        this.type_company = new ALStringField();
        this.type_company.setFieldName("\u793e\u5185\uff0f\u793e\u5916");
        this.type_company.setValue(Integer.toString(1));
        this.current_internal_group_name = new ALStringField();
        this.current_internal_group_name.setFieldName("\u30b0\u30eb\u30fc\u30d7\u540d");
        this.current_internal_group_name.setValue("all");
        this.current_external_group_name = new ALStringField();
        this.current_external_group_name.setFieldName("\u30b0\u30eb\u30fc\u30d7\u540d");
        this.current_external_group_name.setValue("all");
    }

    public List<TurbineUser> getInternalUsers() {
        String groupName = this.getCurrentInternalGroupName().toString();
        if (groupName == null || groupName.equals("") || groupName.equals("all")) {
            groupName = "LoginUser";
        }
        return this.getPostMygroupUsers(groupName);
    }

    public List<AddressBookUserEmailLiteBean> getExternalUsers() {
        String groupId = this.getCurrentExternalGroupName().toString();
        try {
            return AddressBookUserUtils.getAddressBookUserEmailLiteBeansFromGroup((String)groupId, (int)this.userId);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private List<TurbineUser> getPostMygroupUsers(String groupName) {
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"turbineUserGroupRole.turbineGroup.groupName", (Object)groupName);
            Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            query.setQualifier(exp1.andExp(exp2));
            query.orderAscending("eipMUserPosition.position");
            return query.fetchList();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALStringField> getToRecipientList() {
        return this.toRecipientList;
    }

    public List<ALStringField> getCcRecipientList() {
        return this.ccRecipientList;
    }

    public List<ALStringField> getBccRecipientList() {
        return this.bccRecipientList;
    }

    public ALStringField getTypeCompany() {
        return this.type_company;
    }

    public void setTypeCompany(String string) {
        this.type_company.setValue(string);
    }

    public List<ALEipGroup> getInternalGroupList() {
        return this.internalGroupList;
    }

    public List<AddressBookUserGroupLiteBean> getExternalGroupList() {
        return this.externalGroupList;
    }

    public ALStringField getCurrentInternalGroupName() {
        return this.current_internal_group_name;
    }

    public void setCurrentInternalGroupName(String string) {
        this.current_internal_group_name.setValue(string);
    }

    public ALStringField getCurrentExternalGroupName() {
        return this.current_external_group_name;
    }

    public void setCurrentExternalGroupName(String string) {
        this.current_external_group_name.setValue(string);
    }
}

