/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.file;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.file.ALFileLocalFolder;
import com.aimluck.eip.mail.file.ALFilePop3MailReceiver;
import com.aimluck.eip.mail.file.ALFileSmtpMailSender;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.util.orgutils.ALOrgUtilsFactoryService;
import com.aimluck.eip.util.orgutils.ALOrgUtilsHandler;
import java.io.File;
import java.io.IOException;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALFileMailHandler
extends ALMailHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALFileMailHandler.class.getName());
    protected String categoryKey = null;

    private ALFileMailHandler() {
    }

    public static ALMailHandler getInstance() {
        return new ALFileMailHandler();
    }

    protected ALMailReceiver getALMailReceiver(ALMailReceiverContext rcontext) {
        return new ALFilePop3MailReceiver(rcontext);
    }

    public ALMailSender getALMailSender(ALMailSenderContext scontext) {
        return new ALFileSmtpMailSender(scontext);
    }

    public ALFolder getALFolder(int type_mail, String org_id, int user_id, int account_id) {
        return new ALFileLocalFolder(type_mail, org_id, user_id, account_id);
    }

    protected String getCategoryKey() {
        return this.categoryKey != null && !"".equals(this.categoryKey) ? this.categoryKey : ALMailUtils.categoryKey;
    }

    public boolean removeAccount(String org_id, int user_id, int account_id) {
        StringBuffer fullName = null;
        String categoryKeytmp = this.getCategoryKey();
        if (categoryKeytmp != null && !"".equals(categoryKeytmp)) {
            ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
            File docPath = handler.getDocumentPath(ALMailUtils.rootFolderPath, org_id, categoryKeytmp);
            String pathStr = null;
            try {
                pathStr = docPath.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Object)("ALFileMailHandler: unable to resolve file path for " + pathStr));
            }
            fullName = new StringBuffer(pathStr);
            fullName.append(File.separator).append(user_id).append(File.separator).append(account_id);
        } else {
            fullName = new StringBuffer(ALMailUtils.rootFolderPath);
            fullName.append(File.separator).append(org_id).append(File.separator).append(user_id).append(File.separator).append(account_id);
        }
        String path = fullName.toString();
        File folder = new File(path);
        return ALMailUtils.deleteFolder(folder);
    }
}

