/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.db;

import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAbstractFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.SelectQuery;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALDbLocalFolder
extends ALAbstractFolder {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDbLocalFolder.class.getName());

    public ALDbLocalFolder(int type_mail, String org_id, int user_id, int account_id) {
        super(type_mail, org_id, user_id, account_id);
    }

    @Override
    public ALLocalMailMessage getMail(int mailid) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            EipTMail email = (EipTMail)query.setQualifier(exp1.andExp(exp2)).fetchSingle();
            if (email == null) {
                logger.debug((Object)"[Mail] Not found ID...");
                return null;
            }
            ALLocalMailMessage msg = this.readMail(new String(email.getMail()));
            email.setReadFlg("T");
            Database.commit();
            return msg;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return null;
        }
    }

    private ALLocalMailMessage readMail(String mail) {
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        System.setProperty("mail.mime.decodetext.strict", "false");
        Properties prop = new Properties();
        prop.setProperty("mail.mime.address.strict", "false");
        ALLocalMailMessage localmsg = null;
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(mail.getBytes());
            localmsg = new ALLocalMailMessage(Session.getDefaultInstance((Properties)prop), input);
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return localmsg;
    }

    @Override
    public boolean saveMail(ALMailMessage mail, String orgId) {
        try {
            DataContext dataContext = null;
            dataContext = orgId == null || "".equals(orgId) ? DatabaseOrmService.getInstance().getDataContext() : DataContext.createDataContext((String)orgId);
            this.insertMailToDB(dataContext, (MimeMessage)mail, null, true, true);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveDefectiveMail(ALMailMessage mail, String orgId) {
        try {
            DataContext dataContext = null;
            dataContext = orgId == null || "".equals(orgId) ? DatabaseOrmService.getInstance().getDataContext() : DataContext.createDataContext((String)orgId);
            this.insertMailToDB(dataContext, (MimeMessage)mail, null, false, false);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMail(int mailid) {
        try {
            SelectQuery query = Database.query(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            Expression exp3 = ExpressionFactory.matchExp((String)"accountId", (Object)this.account_id);
            query.andQualifier(exp1).andQualifier(exp2).andQualifier(exp3);
            EipTMail mail = (EipTMail)query.setQualifier(exp1.andExp(exp2).andExp(exp3)).fetchSingle();
            if (mail == null) {
                logger.debug((Object)"[ALDbLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            Database.delete((Persistent)mail);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)t);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMails(List<String> msgIndexes) {
        return false;
    }

    @Override
    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("subject", "subject");
        map.putValue("person", "person");
        map.putValue("date", "eventDate");
        map.putValue("volume", "fileVolume");
        return map;
    }

    @Override
    public int getNewMailNum() {
        return 0;
    }

    @Override
    public void setNewMailNum(int num) {
    }

    public int getMailSum() {
        return 0;
    }

    @Override
    public int getUnreadMailNum() {
        return 0;
    }

    @Override
    public void close() {
    }
}

