/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            int valuesize = values.size();
            for (int i = 0; i < valuesize; ++i) {
                String value = values.get(i);
                if ("1".equals(value)) continue;
                intValues.add(Integer.valueOf(value));
            }
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"CATEGORY_ID", intValues);
            query.setQualifier(exp1);
            List categorylist = query.fetchList();
            if (categorylist == null || categorylist.size() == 0) {
                return false;
            }
            Database.deleteAll((List)categorylist);
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            for (EipTWorkflowCategory category : categorylist) {
                categoryIds.add(category.getCategoryId());
            }
            SelectQuery reqquery = Database.query(EipTWorkflowRequest.class);
            Expression reqexp1 = ExpressionFactory.inDbExp((String)"eipTWorkflowCategory.CATEGORY_ID", categoryIds);
            reqquery.setQualifier(reqexp1);
            List requests = reqquery.fetchList();
            if (requests != null && requests.size() > 0) {
                EipTWorkflowCategory defaultCategory = WorkflowUtils.getEipTWorkflowCategory(1L);
                for (EipTWorkflowRequest request : requests) {
                    request.setEipTWorkflowCategory(defaultCategory);
                }
            }
            Database.commit();
            for (EipTWorkflowCategory category : categorylist) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

