/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.DynamicURI;

public class ALCommonUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCommonUtils.class.getName());
    public static final String DEF_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final int DEF_RANDOM_LENGTH = 16;
    private static SecureRandom random = ALCommonUtils.getSecureRandom();

    public static String escapeXML(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    public static String escapeXML(DynamicURI uri) {
        return StringEscapeUtils.escapeXml((String)uri.toString());
    }

    public static String replaceToAutoCRString(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = new StringBuffer("");
        int step = 6;
        int size = str.length();
        int count = size / step;
        for (int i = 0; i < count; ++i) {
            int j = i * step;
            res.append(str.substring(j, j + step)).append("<wbr/>");
        }
        if (count * step < size) {
            res.append(str.substring(count * step));
        }
        return res.toString();
    }

    public static String replaceToAutoCRChild(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = null;
        int findex = str.indexOf("&");
        int lindex = str.indexOf(";");
        if (findex == -1 && lindex == -1) {
            return ALCommonUtils.replaceToAutoCRString(str);
        }
        if (lindex != -1 && (findex == -1 || findex > lindex)) {
            String head = str.substring(0, lindex);
            String body = str.substring(lindex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else if (findex != -1 && lindex == -1) {
            String head = str.substring(0, findex);
            String body = str.substring(findex, findex + 1);
            String tail = str.substring(findex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else {
            String head = str.substring(0, findex);
            String body = str.substring(findex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRString(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        }
        return res.toString();
    }

    public static String replaceToAutoCR(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer res = null;
        int findex = str.indexOf("<");
        int lindex = str.indexOf(">");
        if (findex == -1 && lindex == -1) {
            return ALCommonUtils.replaceToAutoCRChild(str);
        }
        if (findex == -1 || findex > lindex) {
            String head = str.substring(0, lindex);
            String body = str.substring(lindex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else if (lindex == -1) {
            String head = str.substring(0, findex);
            String body = str.substring(findex, findex + 1);
            String tail = str.substring(findex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        } else {
            String head = str.substring(0, findex);
            String body = str.substring(findex, lindex + 1);
            String tail = str.substring(lindex + 1);
            res = new StringBuffer();
            res.append(ALCommonUtils.replaceToAutoCRChild(head));
            res.append(body);
            res.append(ALCommonUtils.replaceToAutoCR(tail));
        }
        return res.toString();
    }

    public static String compressString(String src, int length) {
        String subject;
        if (src == null || src.length() == 0 || length <= 0) {
            return src;
        }
        if (src.length() > length) {
            subject = src.substring(0, length);
            subject = subject + "\u30fb\u30fb\u30fb";
        } else {
            subject = src;
        }
        return subject;
    }

    public static String getSecureRandomString() {
        String res = null;
        try {
            if (null == random) {
                return null;
            }
            byte[] b = new byte[16];
            random.nextBytes(b);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(b);
            StringBuffer sb = new StringBuffer();
            for (byte _b : b) {
                sb.append(String.format("%02x", _b));
            }
            res = sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return res;
    }

    public static SecureRandom getSecureRandom() {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance(DEF_RANDOM_ALGORITHM);
            byte[] seed = random.generateSeed(16);
            random.setSeed(seed);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return random;
    }

    public static String normalizeURL(String url) {
        String res = url;
        if (!res.contains("://")) {
            res = "http://" + res;
        }
        return res;
    }
}

