/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineRole;
import com.aimluck.eip.cayenne.om.security.TurbineRolePermission;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.security.BaseJetspeedGroupRole;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CachedAcl;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.RoleException;
import org.apache.jetspeed.services.security.RoleManagement;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALRoleManagement
extends TurbineBaseService
implements RoleManagement {
    private JetspeedRunDataService runDataService = null;
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private boolean cascadeDelete;
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;

    public Iterator<?> getRoles(String username) throws JetspeedSecurityException {
        HashMap<String, Object> roles;
        JetspeedUser user = null;
        try {
            Iterator result;
            if (this.cachingEnable && null != (result = JetspeedSecurityCache.getRoles((String)username))) {
                return result;
            }
            user = JetspeedSecurity.getUser((Principal)new UserNamePrincipal(username));
        }
        catch (JetspeedSecurityException e) {
            throw new RoleException("Failed to Retrieve User: ", (Throwable)e);
        }
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(user.getUserId()));
            List<TurbineUserGroupRole> rels = Database.query(TurbineUserGroupRole.class, exp).fetchList();
            roles = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, BaseJetspeedGroupRole>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineUserGroupRole rel = rels.get(ix);
                TurbineRole role = rel.getTurbineRole();
                TurbineGroup group = rel.getTurbineGroup();
                BaseJetspeedGroupRole groupRole = new BaseJetspeedGroupRole();
                groupRole.setGroup((Group)group);
                groupRole.setRole((Role)role);
                roles.put(group.getName() + role.getName(), groupRole);
            }
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", (Throwable)e);
        }
        return roles.values().iterator();
    }

    public Iterator<?> getRoles() throws JetspeedSecurityException {
        List<TurbineRole> roles;
        try {
            roles = Database.query(TurbineRole.class).fetchList();
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve roles ", (Throwable)e);
        }
        return roles.iterator();
    }

    public void addRole(Role role) throws JetspeedSecurityException {
        if (this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' already exists");
        }
        try {
            TurbineRole trole = Database.create(TurbineRole.class);
            trole.setName(role.getName());
            trole.setObjectdata(null);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            throw new RoleException("Failed to create role '" + role.getName() + "'", (Throwable)e);
        }
        if (this.cachingEnable) {
            JetspeedSecurityCache.addRole((Role)role);
        }
        try {
            this.addDefaultRolePSML(role);
        }
        catch (Exception e) {
            try {
                this.removeRole(role.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RoleException("failed to add default PSML for Role resource", (Throwable)e);
        }
    }

    protected void addDefaultRolePSML(Role role) throws RoleException {
        try {
            JetspeedRunDataService runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
            JetspeedRunData rundata = runDataService.getCurrentRunData();
            Profile profile = Profiler.createProfile();
            profile.setRole(role);
            profile.setMediaType("html");
            Profiler.createProfile((RunData)rundata, (Profile)profile);
        }
        catch (ProfileException e) {
            try {
                this.removeRole(role.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RoleException("Failed to create Role PSML", (Throwable)e);
        }
    }

    public void saveRole(Role role) throws JetspeedSecurityException {
        if (!this.roleExists(role.getName())) {
            throw new RoleException("The role '" + role.getName() + "' doesn't exists");
        }
        try {
            if (!(role instanceof TurbineRole)) {
                throw new RoleException("TurbineRoleManagment: Role is not a Turbine role, cannot update");
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            throw new RoleException("Failed to create role '" + role.getName() + "'", (Throwable)e);
        }
    }

    public void removeRole(String rolename) throws JetspeedSecurityException {
        try {
            Role role = this.getRole(rolename);
            if (this.cascadeDelete) {
                Expression exp1 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
                Database.query(TurbineUserGroupRole.class, exp1).deleteAll();
                Expression exp2 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
                Database.query(TurbineRolePermission.class, exp2).deleteAll();
            }
            Database.delete((Persistent)((TurbineRole)role));
            PsmlManager.removeRoleDocuments((Role)role);
            Database.commit();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeAllRoles((String)rolename);
            }
        }
        catch (Exception e) {
            Database.rollback();
            throw new RoleException("Failed to remove role '" + rolename + "'", (Throwable)e);
        }
    }

    public void grantRole(String username, String rolename) throws JetspeedSecurityException {
        this.grantRole(username, rolename, "Jetspeed");
    }

    public void grantRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup((String)groupname);
            TurbineUserGroupRole user_group_role = Database.create(TurbineUserGroupRole.class);
            TurbineUser tuser = Database.get(TurbineUser.class, Integer.valueOf(user.getUserId()));
            user_group_role.setTurbineUser(tuser);
            user_group_role.setTurbineGroup((TurbineGroup)group);
            user_group_role.setTurbineRole((TurbineRole)role);
            Database.commit();
            if (this.cachingEnable) {
                JetspeedSecurityCache.addRole((String)username, (Role)role, (Group)group);
            }
        }
        catch (Exception e) {
            Database.rollback();
            throw new RoleException("Grant role '" + rolename + "' to user '" + username + "' failed: ", (Throwable)e);
        }
    }

    public void revokeRole(String username, String rolename) throws JetspeedSecurityException {
        this.revokeRole(username, rolename, "Jetspeed");
    }

    public void revokeRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        try {
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup((String)groupname);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(user.getUserId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            query.andQualifier(exp3);
            query.deleteAll();
            Database.commit();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removeRole((String)username, (String)rolename, (String)groupname);
            }
        }
        catch (Exception e) {
            throw new RoleException("Revoke role '" + rolename + "' to user '" + username + "' failed: ", (Throwable)e);
        }
    }

    public boolean hasRole(String username, String rolename) throws JetspeedSecurityException {
        return this.hasRole(username, rolename, "Jetspeed");
    }

    public boolean hasRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        List<TurbineUserGroupRole> roles;
        try {
            CachedAcl acl;
            if (this.cachingEnable && null != (acl = JetspeedSecurityCache.getAcl((String)username))) {
                return acl.hasRole(rolename, groupname);
            }
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            Role role = this.getRole(rolename);
            Group group = JetspeedSecurity.getGroup((String)groupname);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(user.getUserId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(group.getId()));
            Expression exp3 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            SelectQuery<TurbineUserGroupRole> query = Database.query(TurbineUserGroupRole.class);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            query.andQualifier(exp3);
            roles = query.fetchList();
        }
        catch (Exception e) {
            throw new RoleException("Failed to check role '" + rolename + "'", (Throwable)e);
        }
        return roles.size() > 0;
    }

    public Role getRole(String rolename) throws JetspeedSecurityException {
        List<TurbineRole> roles;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"roleName", (Object)rolename);
            roles = Database.query(TurbineRole.class, exp).fetchList();
        }
        catch (Exception e) {
            throw new RoleException("Failed to retrieve role '" + rolename + "'", (Throwable)e);
        }
        if (roles.size() > 1) {
            throw new RoleException("Multiple Roles with same rolename '" + rolename + "'");
        }
        if (roles.size() == 1) {
            TurbineRole role = roles.get(0);
            return role;
        }
        throw new RoleException("Unknown role '" + rolename + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean roleExists(String roleName) throws RoleException {
        List<TurbineRole> roles;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"roleName", (Object)roleName);
            roles = Database.query(TurbineRole.class, exp).fetchList();
        }
        catch (Exception e) {
            throw new RoleException("Failed to check account's presence", (Throwable)e);
        }
        return roles.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.setInit(true);
    }
}

