/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.security;

import com.aimluck.eip.cayenne.om.security.TurbinePermission;
import com.aimluck.eip.cayenne.om.security.TurbineRolePermission;
import com.aimluck.eip.orm.Database;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.PermissionException;
import org.apache.jetspeed.services.security.PermissionManagement;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALPermissionManagement
extends TurbineBaseService
implements PermissionManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALPermissionManagement.class.getName());
    private JetspeedRunDataService runDataService = null;
    private static final String CASCADE_DELETE = "programmatic.cascade.delete";
    private static final boolean DEFAULT_CASCADE_DELETE = true;
    private static final String CONFIG_SYSTEM_PERMISSIONS = "system.permissions";
    private boolean cascadeDelete;
    private static final String CACHING_ENABLE = "caching.enable";
    private boolean cachingEnable = true;
    private Vector<?> systemPermissions = null;

    public Iterator<?> getPermissions(String rolename) throws JetspeedSecurityException {
        HashMap<String, Object> perms;
        Role role = null;
        try {
            Iterator iterator;
            if (this.cachingEnable && (iterator = JetspeedSecurityCache.getPermissions((String)rolename)) != null) {
                return iterator;
            }
            role = JetspeedSecurity.getRole((String)rolename);
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"Failed to Retrieve Role: ", (Throwable)e);
            throw new PermissionException("Failed to Retrieve Role: ", (Throwable)e);
        }
        try {
            Expression exp = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            List<TurbineRolePermission> rels = Database.query(TurbineRolePermission.class, exp).fetchList();
            perms = rels.size() > 0 ? new HashMap(rels.size()) : new HashMap<String, TurbinePermission>();
            for (int ix = 0; ix < rels.size(); ++ix) {
                TurbineRolePermission rel = rels.get(ix);
                TurbinePermission perm = rel.getTurbinePermission();
                perms.put(perm.getName(), perm);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve permissions ", (Throwable)e);
            throw new PermissionException("Failed to retrieve permissions ", (Throwable)e);
        }
        return perms.values().iterator();
    }

    public Iterator<TurbinePermission> getPermissions() throws JetspeedSecurityException {
        List<TurbinePermission> permissions;
        try {
            permissions = Database.query(TurbinePermission.class).fetchList();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve permissions ", (Throwable)e);
            throw new PermissionException("Failed to retrieve permissions ", (Throwable)e);
        }
        return permissions.iterator();
    }

    public void addPermission(Permission permission) throws JetspeedSecurityException {
        if (this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' already exists");
        }
        try {
            TurbinePermission tpermission = Database.create(TurbinePermission.class);
            tpermission.setName(permission.getName());
            tpermission.setOBJECTDATA(null);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
    }

    public void savePermission(Permission permission) throws JetspeedSecurityException {
        if (!this.permissionExists(permission.getName())) {
            throw new PermissionException("The permission '" + permission.getName() + "' doesn't exists");
        }
        try {
            if (!(permission instanceof TurbinePermission)) {
                throw new PermissionException("TurbinePermissionManagment: Permission is not a Turbine permission, cannot update");
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            String message = "Failed to create permission '" + permission.getName() + "'";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
    }

    public void removePermission(String permissionName) throws JetspeedSecurityException {
        try {
            block6: {
                try {
                    if (this.systemPermissions.contains(permissionName)) {
                        throw new PermissionException("[" + permissionName + "] is a system permission and cannot be removed");
                    }
                    Permission permission = this.getPermission(permissionName);
                    if (this.cascadeDelete) {
                        Expression exp = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
                        Database.query(TurbineRolePermission.class, exp).deleteAll();
                    }
                    Database.delete((Persistent)((TurbineRolePermission)permission));
                    Database.commit();
                    if (!this.cachingEnable) break block6;
                    JetspeedSecurityCache.removeAllPermissions((String)permissionName);
                }
                catch (Exception e) {
                    String message = "Failed to remove permission '" + permissionName + "'";
                    logger.error((Object)message, (Throwable)e);
                    throw new PermissionException(message, (Throwable)e);
                }
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    public void grantPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole((String)roleName);
            Permission permission = this.getPermission(permissionName);
            TurbineRolePermission role_permission = Database.create(TurbineRolePermission.class);
            role_permission.setRoleId(Integer.parseInt(role.getId()));
            role_permission.setPermissionId(Integer.parseInt(permission.getId()));
            Database.commit();
        }
        catch (Exception e) {
            String message = "Grant permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
    }

    public void revokePermission(String roleName, String permissionName) throws JetspeedSecurityException {
        try {
            Role role = JetspeedSecurity.getRole((String)roleName);
            Permission permission = this.getPermission(permissionName);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
            Database.query(TurbineRolePermission.class, exp1).andQualifier(exp2).deleteAll();
            if (this.cachingEnable) {
                JetspeedSecurityCache.removePermission((String)roleName, (String)permissionName);
            }
        }
        catch (Exception e) {
            Database.rollback();
            String message = "Revoke permission '" + permissionName + "' to role '" + roleName + "' failed: ";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
    }

    public boolean hasPermission(String roleName, String permissionName) throws JetspeedSecurityException {
        List<TurbineRolePermission> permissions;
        try {
            if (this.cachingEnable) {
                return JetspeedSecurityCache.hasPermission((String)roleName, (String)permissionName);
            }
            Role role = JetspeedSecurity.getRole((String)roleName);
            Permission permission = this.getPermission(permissionName);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"ROLE_ID", (Object)Integer.valueOf(role.getId()));
            Expression exp2 = ExpressionFactory.matchDbExp((String)"PERMISSION_ID", (Object)Integer.valueOf(permission.getId()));
            permissions = Database.query(TurbineRolePermission.class, exp1).andQualifier(exp2).fetchList();
        }
        catch (Exception e) {
            String message = "Failed to check permission '" + permissionName + "'";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
        return permissions.size() > 0;
    }

    public Permission getPermission(String permissionName) throws JetspeedSecurityException {
        List<TurbinePermission> permissions;
        try {
            permissions = Database.query(TurbinePermission.class).fetchList();
        }
        catch (Exception e) {
            String message = "Failed to retrieve permission '" + permissionName + "'";
            logger.error((Object)message, (Throwable)e);
            throw new PermissionException(message, (Throwable)e);
        }
        if (permissions.size() > 1) {
            throw new PermissionException("Multiple Permissions with same permissionname '" + permissionName + "'");
        }
        if (permissions.size() == 1) {
            TurbinePermission permission = permissions.get(0);
            return permission;
        }
        throw new PermissionException("Unknown permission '" + permissionName + "'");
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    protected boolean permissionExists(String permissionName) throws PermissionException {
        List<TurbinePermission> permissions;
        try {
            Expression exp = ExpressionFactory.matchExp((String)"permissionName", (Object)permissionName);
            permissions = Database.query(TurbinePermission.class, exp).fetchList();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to check account's presence", (Throwable)e);
            throw new PermissionException("Failed to check account's presence", (Throwable)e);
        }
        return permissions.size() >= 1;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.cascadeDelete = serviceConf.getBoolean(CASCADE_DELETE, true);
        this.cachingEnable = serviceConf.getBoolean(CACHING_ENABLE, this.cachingEnable);
        this.systemPermissions = serviceConf.getVector(CONFIG_SYSTEM_PERMISSIONS, new Vector());
        this.setInit(true);
    }
}

