/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.accessctl.empty;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALEmptyAccessControlHandler
extends ALAccessControlHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEmptyAccessControlHandler.class.getName());

    @Override
    public boolean hasAuthority(int userId, String featerName, int aclType) {
        if ("schedule_other".equals(featerName)) {
            boolean updatable = (aclType & 8) == 8;
            boolean deletable = (aclType & 0x10) == 16;
            return !updatable && !deletable;
        }
        return true;
    }

    @Override
    public List<Integer> getAcceptUserIdsExceptLoginUser(int uid, String feat, int acl_type) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE ");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        String sqlString = sb.toString();
        List<TurbineUser> list = Database.sql(TurbineUser.class, sqlString).fetchList();
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (list == null || list.size() < 1) {
            return userIds;
        }
        for (TurbineUser user : list) {
            userIds.add(user.getUserId());
        }
        return userIds;
    }

    @Override
    public List<Integer> getAcceptUserIdsInListExceptLoginUser(int uid, String feat, int acl_type, List<ALEipUser> ulist) {
        int u_size;
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        if (ulist == null || (u_size = ulist.size()) < 1) {
            return userIds;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("USER_ID");
        sb.append(" FROM TURBINE_USER WHERE (");
        sb.append("USER_ID");
        sb.append(" in (");
        for (int i = 0; i < u_size; ++i) {
            ALEipUser member = ulist.get(i);
            sb.append(Long.toString(member.getUserId().getValue()));
            if (i + 1 >= u_size) continue;
            sb.append(",");
        }
        sb.append(")) AND (");
        sb.append("USER_ID");
        sb.append(" != ");
        sb.append(Integer.toString(uid));
        sb.append(")");
        String sqlString = sb.toString();
        List<TurbineUser> list = Database.sql(TurbineUser.class, sqlString).fetchList();
        if (list == null || list.size() < 1) {
            return userIds;
        }
        for (TurbineUser tuser : list) {
            userIds.add(tuser.getUserId());
        }
        return userIds;
    }

    @Override
    public List<TurbineUser> getAuthorityUsersFromGroup(RunData rundata, String feat, String groupname, boolean includeLoginuser) {
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        return Database.sql(TurbineUser.class, statement.toString()).param("groupname", groupname).fetchList();
    }

    @Override
    public void insertDefaultRole(int uid) throws Exception {
    }
}

