/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.query;

import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.AbstractQuery;
import com.aimluck.eip.orm.query.CountQuery;
import com.aimluck.eip.orm.query.CustomSelectQuery;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.Where;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQuery<M>
extends AbstractQuery<M> {
    private static final long serialVersionUID = 5404111688862773398L;
    protected CustomSelectQuery delegate;
    protected CountQuery countQuery;
    protected int page = 1;
    protected int totalCount = 0;

    public SelectQuery(Class<M> rootClass) {
        super(rootClass);
        this.delegate = new CustomSelectQuery(rootClass);
        this.countQuery = new CountQuery(rootClass);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public SelectQuery(DataContext dataContext, Class<M> rootClass) {
        super(dataContext, rootClass);
        this.rootClass = rootClass;
        this.delegate = new CustomSelectQuery(rootClass);
        this.countQuery = new CountQuery(rootClass);
        this.dataContext = dataContext;
    }

    public SelectQuery(Class<M> rootClass, Expression qualifier) {
        super(rootClass);
        this.rootClass = rootClass;
        this.delegate = new CustomSelectQuery(rootClass, qualifier);
        this.countQuery = new CountQuery(rootClass);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public SelectQuery(DataContext dataContext, Class<M> rootClass, Expression qualifier) {
        super(dataContext, rootClass);
        this.rootClass = rootClass;
        this.delegate = new CustomSelectQuery(rootClass, qualifier);
        this.countQuery = new CountQuery(rootClass);
        this.dataContext = dataContext;
    }

    @Override
    public List<M> fetchList() {
        if (this.delegate.isFetchingDataRows()) {
            List dataRows = this.dataContext.performQuery((Query)this.delegate);
            ArrayList results = new ArrayList();
            for (DataRow dataRow : dataRows) {
                Object model = this.newInstanceFromRowData(dataRow, this.rootClass);
                if (model == null) continue;
                results.add(model);
            }
            return results;
        }
        return this.dataContext.performQuery((Query)this.delegate);
    }

    public ResultList<M> getResultList() {
        this.countQuery.setCustomColumns(this.getPrimaryKey());
        int totalCount = this.countQuery.count(this.dataContext, this.delegate.isDistinct());
        int pageSize = this.delegate.getFetchLimit();
        if (pageSize > 0) {
            int num = (int)Math.ceil((double)totalCount / (double)pageSize);
            if (num > 0 && num < this.page) {
                this.page = num;
            }
            int offset = pageSize * (this.page - 1);
            this.offset(offset);
        } else {
            this.page = 1;
        }
        List<M> fetchList = this.fetchList();
        return new ResultList<M>(fetchList, this.page, this.delegate.getPageSize(), totalCount);
    }

    public int getCount() {
        this.countQuery.setCustomColumns(this.getPrimaryKey());
        return this.countQuery.count(this.dataContext, this.delegate.isDistinct());
    }

    public SelectQuery<M> where(Where where) {
        this.delegate.andQualifier(where.exp);
        this.countQuery.andQualifier(where.exp);
        return this;
    }

    public SelectQuery<M> where(Where ... where) {
        List<Where> list = Arrays.asList(where);
        for (Where w : list) {
            this.delegate.andQualifier(w.exp);
            this.countQuery.andQualifier(w.exp);
        }
        return this;
    }

    public SelectQuery<M> setQualifier(Expression qualifier) {
        this.delegate.setQualifier(qualifier);
        this.countQuery.setQualifier(qualifier);
        return this;
    }

    public SelectQuery<M> andQualifier(Expression qualifier) {
        this.delegate.andQualifier(qualifier);
        this.countQuery.andQualifier(qualifier);
        return this;
    }

    public SelectQuery<M> andQualifier(String qualifier) {
        this.delegate.andQualifier(Expression.fromString((String)qualifier));
        this.countQuery.andQualifier(Expression.fromString((String)qualifier));
        return this;
    }

    public SelectQuery<M> orQualifier(Expression qualifier) {
        this.delegate.orQualifier(qualifier);
        this.countQuery.orQualifier(qualifier);
        return this;
    }

    public SelectQuery<M> orQualifier(String qualifier) {
        this.delegate.orQualifier(Expression.fromString((String)qualifier));
        this.countQuery.orQualifier(Expression.fromString((String)qualifier));
        return this;
    }

    public SelectQuery<M> orderAscending(String ordering) {
        this.delegate.addOrdering(ordering, true);
        return this;
    }

    public SelectQuery<M> orderDesending(String ordering) {
        this.delegate.addOrdering(ordering, false);
        return this;
    }

    public SelectQuery<M> page(int page) {
        this.page = page;
        return this;
    }

    public SelectQuery<M> limit(int limit) {
        this.delegate.setFetchLimit(limit);
        return this;
    }

    public SelectQuery<M> offset(int offset) {
        this.delegate.setFetchOffset(offset);
        return this;
    }

    public SelectQuery<M> select(String column) {
        this.delegate.addCustomColumn(column);
        this.delegate.setFetchingDataRows(true);
        return this;
    }

    public SelectQuery<M> select(String ... columns) {
        this.delegate.addCustomColumns(columns);
        this.delegate.setFetchingDataRows(true);
        return this;
    }

    public SelectQuery<M> distinct() {
        this.delegate.setDistinct(true);
        this.countQuery.setDistinct(true);
        return this;
    }

    public SelectQuery<M> distinct(boolean isDistinct) {
        this.delegate.setDistinct(isDistinct);
        this.countQuery.setDistinct(isDistinct);
        return this;
    }

    public SelectQuery<M> prefetch(String column) {
        this.delegate.addPrefetch(column);
        return this;
    }

    public org.apache.cayenne.query.SelectQuery getQuery() {
        return this.delegate;
    }

    protected String getPrimaryKey() {
        ObjEntity objEntity = this.dataContext.getEntityResolver().lookupObjEntity(this.rootClass);
        List primaryKey = objEntity.getDbEntity().getPrimaryKey();
        DbAttribute dbAttribute = (DbAttribute)primaryKey.get(0);
        return dbAttribute.getName();
    }
}

