/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.query;

import com.aimluck.eip.orm.query.AbstractCustomQuery;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.query.Query;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountQuery
extends AbstractCustomQuery {
    private static final long serialVersionUID = 7286490109199978350L;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CountQuery.class.getName());
    private boolean isDistinct = false;
    private String customColumns;

    public CountQuery() {
    }

    public CountQuery(Class<?> rootClass) {
        super(rootClass);
    }

    public int count(DataContext dataContext) {
        return this.count(dataContext, this.isDistinct);
    }

    public int count(DataContext dataContext, boolean isDistinct) {
        this.isDistinct = isDistinct;
        int ret = 0;
        Map row = null;
        try {
            ResultIterator it = dataContext.performIteratedQuery((Query)this);
            if (it != null && it.hasNextRow()) {
                row = it.nextDataRow();
            }
            if (row != null) {
                ret = (Integer)row.get("C");
            }
        }
        catch (CayenneException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public void setCustomColumns(String customColumns) {
        this.customColumns = customColumns;
    }

    @Override
    protected String getCustomScript() {
        if (this.customColumns == null) {
            return "COUNT(*) AS C";
        }
        if (this.isDistinct) {
            return "COUNT(DISTINCT t0." + this.customColumns + ") AS C";
        }
        return "COUNT(*) AS C";
    }

    @Override
    protected ColumnDescriptor[] getCustomColumnDescriptor() {
        return new ColumnDescriptor[]{new ColumnDescriptor("C", TypesMapping.getSqlTypeByJava(Integer.class), "java.lang.Integer")};
    }

    @Override
    protected String[] getCustomColumnNames() {
        return null;
    }

    @Override
    protected int getFetchOffset() {
        return 0;
    }
}

