/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm.impl;

import com.aimluck.eip.orm.DataContextLocator;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.ServletUtil;
import org.apache.cayenne.map.DataMap;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.RunData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgDatabaseOrmService
extends DatabaseOrmService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PkgDatabaseOrmService.class.getName());
    public static final String ORG_PKG = "org001";

    @Override
    protected void initOrm(ServletContext context) throws InitializationException {
        logger.debug((Object)"initOrm");
        ServletUtil.initializeSharedConfiguration((ServletContext)context);
        DataDomain dataDomain = Configuration.getSharedConfiguration().getDomain("SharedDomain");
        Collection dataMaps = dataDomain.getDataMaps();
        for (DataMap map : dataMaps) {
            logger.debug((Object)("map:" + map.getName()));
            this.copyDataMap("SharedDomain", map.getName(), ORG_PKG);
        }
    }

    @Override
    public String getDefaultOrgId() {
        return ORG_PKG;
    }

    @Override
    public String getOrgId(String company_id) {
        return null;
    }

    @Override
    public String getCompanyId(String org_id) {
        return null;
    }

    @Override
    public String getOrgId(RunData rundata) {
        return ORG_PKG;
    }

    @Override
    public String getOrgId(HttpSession session) {
        return ORG_PKG;
    }

    @Override
    public DataContext getDataContext() {
        JetspeedRunData rundata = this.getRunData();
        try {
            if (rundata == null) {
                DataContext ctxt = DataContext.createDataContext((String)ORG_PKG);
                DataContextLocator.set(ctxt);
                return ctxt;
            }
            return PkgDatabaseOrmService.getDefaultContext(rundata.getSession());
        }
        catch (IllegalStateException e) {
            rundata.setScreenTemplate("Timeout");
            DataContext ctxt = DataContext.createDataContext((String)ORG_PKG);
            DataContextLocator.set(ctxt);
            return ctxt;
        }
    }

    @Override
    public List<String> getOrgKeys() {
        ArrayList<String> orglist = new ArrayList<String>();
        orglist.add(ORG_PKG);
        return orglist;
    }

    @Override
    public String getAlias() {
        return JetspeedResources.getString((String)"aipo.alias");
    }

    @Override
    public String getAliasjp() {
        return JetspeedResources.getString((String)"aipo.aliasjp");
    }

    @Override
    public String getCopyright() {
        return JetspeedResources.getString((String)"aipo.copyright");
    }

    @Override
    public String getCopyrightShort() {
        return JetspeedResources.getString((String)"aipo.copyright_short");
    }

    @Override
    public String getTheme() {
        return JetspeedResources.getString((String)"aipo.theme");
    }
}

