/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.orm.DataContextLocator;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseOrmService
extends TurbineBaseService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)DatabaseOrmService.class.getName());
    public static final String SERVICE_NAME = "DatabaseOrmService";
    public static final String ORG_DEFAULT = "org000";
    public static final String ORG_PRE = "org";
    protected static final String SHARED_DOMAIN = "SharedDomain";
    protected JetspeedRunDataService runDataService = null;

    protected abstract void initOrm(ServletContext var1) throws InitializationException;

    protected void copyDataMap(String srcDataDomainName, String srcDataMapName, String destDataDomainName) {
        DataDomain destDataDomain = Configuration.getSharedConfiguration().getDomain(destDataDomainName);
        if (destDataDomain == null) {
            return;
        }
        DataDomain sharedDataDomain = Configuration.getSharedConfiguration().getDomain(srcDataDomainName);
        destDataDomain.addMap(sharedDataDomain.getMap(srcDataMapName));
        Collection nodes = destDataDomain.getDataNodes();
        if (nodes.size() != 1) {
            return;
        }
        for (DataNode node : nodes) {
            node.addDataMap(sharedDataDomain.getMap(srcDataMapName));
        }
    }

    public static DatabaseOrmService getInstance() {
        return (DatabaseOrmService)TurbineServices.getInstance().getService(SERVICE_NAME);
    }

    public abstract String getOrgId(String var1);

    public abstract String getCompanyId(String var1);

    public abstract String getOrgId(RunData var1);

    public abstract String getOrgId(HttpSession var1);

    public abstract List<String> getOrgKeys();

    public abstract String getDefaultOrgId();

    public static DataContext getDefaultContext(HttpSession session) {
        DataContext ctxt = DataContextLocator.get();
        if (ctxt == null) {
            JetspeedRunData rundata = DatabaseOrmService.getInstance().getRunData();
            if (rundata != null && rundata.getParameters().containsKey((Object)ORG_PRE) && !"".equals(rundata.getParameters().getString(ORG_PRE))) {
                ctxt = DataContext.createDataContext((String)rundata.getParameters().getString(ORG_PRE));
            } else {
                String org_id = DatabaseOrmService.getInstance().getOrgId(rundata.getSession());
                ctxt = DataContext.createDataContext((String)org_id);
            }
            DataContextLocator.set(ctxt);
        }
        return ctxt;
    }

    public DataContext getDataContext() {
        JetspeedRunData rundata = this.getRunData();
        if (rundata == null) {
            return null;
        }
        return DatabaseOrmService.getDefaultContext(rundata.getSession());
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }

    public void addDomain(String jdbcDriver, String dataSourceUrl, int minCons, int maxCons, String userName, String password, String domainName, String dataNodeName) {
        try {
            PoolManager ds = new PoolManager(jdbcDriver, dataSourceUrl, minCons, maxCons, userName, password);
            DataDomain domain = new DataDomain(domainName);
            DataNode node = new DataNode(dataNodeName);
            node.setAdapter((DbAdapter)new AutoAdapter((DataSource)ds));
            node.setDataSource((DataSource)ds);
            node.setDataSourceLocation(dataNodeName + ".driver.xml");
            domain.addNode(node);
            Configuration.getSharedConfiguration().addDomain(domain);
            this.copyDataMap(SHARED_DOMAIN, "AccountSharedDomainMap", domainName);
            this.copyDataMap(SHARED_DOMAIN, "SecuritySharedDomainMap", domainName);
            this.copyDataMap(SHARED_DOMAIN, "SharedDomainMap", domainName);
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR]", (Throwable)e);
        }
    }

    public void removeDomain(String domainName) {
        try {
            DataDomain domain = Configuration.getSharedConfiguration().getDomain(domainName);
            if (domain == null) {
                throw new ALDBErrorException();
            }
            domain.shutdown();
            Configuration.getSharedConfiguration().removeDomain(domainName);
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR]", (Throwable)e);
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.initOrm(conf.getServletContext());
        this.setInit(true);
    }

    public abstract String getAlias();

    public abstract String getAliasjp();

    public abstract String getCopyright();

    public abstract String getCopyrightShort();

    public abstract String getTheme();
}

