/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.orm;

import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.exp.Expression;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)Database.class.getName());

    public static <M> SelectQuery<M> query(Class<M> modelClass) {
        return new SelectQuery<M>(modelClass);
    }

    public static <M> SelectQuery<M> query(DataContext dataContext, Class<M> modelClass) {
        return new SelectQuery<M>(dataContext, modelClass);
    }

    public static <M> SelectQuery<M> query(Class<M> modelClass, Expression exp) {
        return new SelectQuery<M>(modelClass, exp);
    }

    public static <M> SelectQuery<M> query(DataContext dataContext, Class<M> modelClass, Expression exp) {
        return new SelectQuery<M>(dataContext, modelClass, exp);
    }

    public static <M> SQLTemplate<M> sql(Class<M> modelClass, String sql) {
        return new SQLTemplate<M>(modelClass, sql);
    }

    public static <M> SQLTemplate<M> sql(DataContext dataContext, Class<M> modelClass, String sql) {
        return new SQLTemplate<M>(dataContext, modelClass, sql);
    }

    public static <M> M get(Class<M> modelClass, Object primaryKey) {
        return Database.get(DatabaseOrmService.getInstance().getDataContext(), modelClass, primaryKey);
    }

    public static <M> M get(DataContext dataContext, Class<M> modelClass, Object primaryKey) {
        return (M)DataObjectUtils.objectForPK((ObjectContext)dataContext, modelClass, (Object)primaryKey);
    }

    public static <M> M get(Class<M> modelClass, String key, Object value) {
        return Database.get(DatabaseOrmService.getInstance().getDataContext(), modelClass, key, value);
    }

    public static <M> M get(DataContext dataContext, Class<M> modelClass, String key, Object value) {
        return (M)dataContext.refetchObject(new ObjectId(modelClass.getSimpleName(), key, value));
    }

    public static <M> M create(Class<M> modelClass) {
        return Database.create(DatabaseOrmService.getInstance().getDataContext(), modelClass);
    }

    public static <M> M create(DataContext dataContext, Class<M> modelClass) {
        return (M)dataContext.createAndRegisterNewObject(modelClass);
    }

    public static void delete(Persistent target) {
        Database.delete(DatabaseOrmService.getInstance().getDataContext(), target);
    }

    public static void delete(DataContext dataContext, Persistent target) {
        dataContext.deleteObject(target);
    }

    public static void deleteAll(List<?> target) {
        Database.deleteAll(DatabaseOrmService.getInstance().getDataContext(), target);
    }

    public static void deleteAll(DataContext dataContext, List<?> target) {
        dataContext.deleteObjects(target);
    }

    public static void deleteAll(DataObject ... target) {
        Database.deleteAll(DatabaseOrmService.getInstance().getDataContext(), target);
    }

    public static void deleteAll(DataContext dataContext, DataObject ... target) {
        dataContext.deleteObjects(Arrays.asList(target));
    }

    public static void commit() {
        Database.commit(DatabaseOrmService.getInstance().getDataContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commit(DataContext dataContext) {
        dataContext.commitChanges();
        Transaction threadTransaction = Transaction.getThreadTransaction();
        if (threadTransaction == null) return;
        try {
            try {
                threadTransaction.commit();
            }
            catch (IllegalStateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                Object var4_3 = null;
                Transaction.bindThreadTransaction(null);
                return;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                Object var4_4 = null;
                Transaction.bindThreadTransaction(null);
                return;
            }
            catch (CayenneException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                Object var4_5 = null;
                Transaction.bindThreadTransaction(null);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Transaction.bindThreadTransaction(null);
            throw throwable;
        }
        Transaction.bindThreadTransaction(null);
    }

    public static void rollback() {
        Database.rollback(DatabaseOrmService.getInstance().getDataContext());
    }

    public static void rollback(DataContext dataContext) {
        try {
            dataContext.rollbackChanges();
        }
        catch (Throwable t) {
            logger.warn((Object)t);
        }
    }

    public static Object getFromDataRow(DataRow dataRow, Object key) {
        String lowerKey = ((String)key).toLowerCase();
        if (dataRow.containsKey((Object)lowerKey)) {
            return dataRow.get((Object)lowerKey);
        }
        return dataRow.get((Object)((String)key).toUpperCase());
    }

    private Database() {
    }
}

