/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.orgutils.ALOrgUtilsFactoryService;
import com.aimluck.eip.util.orgutils.ALOrgUtilsHandler;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALVelocityScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALVelocityScreen.class.getName());
    private static final String CONTENT_TYPE = "text/json;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    private String mode;
    private Object result;
    private List<Object> resultList;
    private List<String> msgList;
    private List<String> errmsgList;

    protected void setTemplate(RunData rundata, Context context, String template) {
        try {
            ServletOutputStream out = null;
            HttpServletResponse response = rundata.getResponse();
            out = response.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, ALEipConstants.DEF_CONTENT_ENCODING));
            Template templete = Velocity.getTemplate((String)template);
            templete.merge(context, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"[ALVelocityScreen]", (Throwable)e);
        }
    }

    protected void doOutput(RunData rundata) throws Exception {
        VelocityContext context = new VelocityContext();
        this.mode = rundata.getParameters().getString("mode");
        try {
            ALEipUtils.setupContext(rundata, (Context)context);
            this.doOutput(rundata, (Context)context);
        }
        catch (Exception ex) {
            logger.error((Object)"[ALVelocityScreen] Exception.", (Throwable)ex);
            ALEipUtils.redirectDBError(rundata);
        }
    }

    protected abstract void doOutput(RunData var1, Context var2) throws Exception;

    @Override
    public void setResultData(Object obj) {
        this.result = obj;
    }

    @Override
    public void addResultData(Object obj) {
        if (this.resultList == null) {
            this.resultList = new ArrayList<Object>();
        }
        this.resultList.add(obj);
    }

    @Override
    public void setResultDataList(List<Object> objList) {
        this.resultList = objList;
    }

    @Override
    public void addErrorMessage(String msg) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.add(msg);
    }

    @Override
    public void addErrorMessages(List<String> msgs) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.addAll(msgs);
    }

    @Override
    public void setErrorMessages(List<String> msgs) {
        this.errmsgList = msgs;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void putData(RunData rundata, Context context) {
        context.put("mode", (Object)this.mode);
        context.put("result", this.result);
        context.put("results", this.resultList);
        context.put("msgs", this.msgList);
        context.put("errmsgs", this.errmsgList);
        context.put("entityid", (Object)ALEipUtils.getTemp(rundata, context, "entityid"));
        context.put("config", (Object)new JetspeedResources());
        context.put("utils", (Object)new ALCommonUtils());
        context.put("secid", rundata.getUser().getTemp("secid"));
        ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
        Map<String, String> attribute = handler.getParameters(DatabaseOrmService.getInstance().getOrgId(rundata));
        for (Map.Entry<String, String> e : attribute.entrySet()) {
            context.put(e.getKey(), (Object)e.getValue());
        }
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }
}

