/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALJSONScreen
extends RawScreen
implements ALAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALJSONScreen.class.getName());
    private static final String CONTENT_TYPE = "text/json;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    private String mode = "";
    private Object result;
    private List<Object> resultList;
    private List<String> msgList;
    private List<String> errmsgList;

    protected void doOutput(RunData rundata) throws Exception {
        ServletOutputStream out = null;
        VelocityContext context = new VelocityContext();
        this.mode = rundata.getParameters().containsKey((Object)"mode") ? rundata.getParameters().getString("mode") : "";
        try {
            ALEipUtils.setupContext(rundata, (Context)context);
            StringBuffer result = new StringBuffer().append("/* ").append(this.getJSONString(rundata, (Context)context)).append(" */");
            byte[] byteResult = result.toString().getBytes(ALEipConstants.DEF_CONTENT_ENCODING);
            HttpServletResponse response = rundata.getResponse();
            out = response.getOutputStream();
            out.write(byteResult);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR]", (Throwable)e);
        }
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }

    protected abstract String getJSONString(RunData var1, Context var2) throws Exception;

    @Override
    public void setResultData(Object obj) {
        this.result = obj;
    }

    @Override
    public void addResultData(Object obj) {
        if (this.resultList == null) {
            this.resultList = new ArrayList<Object>();
        }
        this.resultList.add(obj);
    }

    @Override
    public void setResultDataList(List<Object> objList) {
        this.resultList = objList;
    }

    @Override
    public void addErrorMessage(String msg) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.add(msg);
    }

    @Override
    public void addErrorMessages(List<String> msgs) {
        if (this.errmsgList == null) {
            this.errmsgList = new ArrayList<String>();
        }
        this.errmsgList.addAll(msgs);
    }

    @Override
    public void setErrorMessages(List<String> msgs) {
        this.errmsgList = msgs;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void putData(RunData rundata, Context context) {
        context.put("mode", (Object)this.mode);
        context.put("result", this.result);
        context.put("results", this.resultList);
        context.put("msgs", this.msgList);
        context.put("errmsgs", this.errmsgList);
        context.put("entityid", (Object)ALEipUtils.getTemp(rundata, context, "entityid"));
    }
}

